/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.types;

import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.procs.Procs;
import com.impossibl.postgres.system.tables.PGTypeTable;
import com.impossibl.postgres.types.Modifiers;
import com.impossibl.postgres.types.QualifiedName;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.utils.guava.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public abstract class Type
implements TypeRef {
    public static final String CATALOG_NAMESPACE = "pg_catalog";
    public static final String PUBLIC_NAMESPACE = "public";
    private int id;
    private QualifiedName name;
    private Short length;
    private Byte alignment;
    private Category category;
    private Character delimeter;
    private int arrayTypeId;
    private int relationId;
    private TextCodec textCodec;
    private BinaryCodec binaryCodec;
    private Modifiers.Parser modifierParser;
    private FieldFormat preferredParameterFormat;
    private FieldFormat preferredResultFormat;

    public Type() {
    }

    public Type(int id, String name, String namespace, Short length, Byte alignment, Category category, Character delimeter, Integer arrayTypeId, BinaryCodec binaryCodec, TextCodec textCodec, Modifiers.Parser modifierParser, FieldFormat preferredParameterFormat, FieldFormat preferredResultFormat) {
        this.id = id;
        this.name = new QualifiedName(namespace, name);
        this.length = length;
        this.alignment = alignment;
        this.category = Preconditions.checkNotNull(category);
        this.delimeter = delimeter;
        this.arrayTypeId = arrayTypeId;
        this.binaryCodec = binaryCodec;
        this.textCodec = textCodec;
        this.modifierParser = modifierParser;
        this.preferredParameterFormat = preferredParameterFormat;
        this.preferredResultFormat = preferredResultFormat;
    }

    @Override
    public int getOid() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name.getLocalName();
    }

    public String getNamespace() {
        return this.name.getNamespace();
    }

    public QualifiedName getQualifiedName() {
        return this.name;
    }

    public Short getLength() {
        return this.length;
    }

    public Byte getAlignment() {
        return this.alignment;
    }

    public Category getCategory() {
        return this.category;
    }

    public char getDelimeter() {
        return this.delimeter.charValue();
    }

    public int getArrayTypeId() {
        return this.arrayTypeId;
    }

    public Boolean isNullable() {
        return null;
    }

    public String getDefaultValue() {
        return null;
    }

    public boolean isAutoIncrement() {
        return Type.isAutoIncrement(this.getDefaultValue());
    }

    public static boolean isAutoIncrement(String defaultValue) {
        return defaultValue != null && defaultValue.startsWith("nextval(");
    }

    public BinaryCodec getBinaryCodec() {
        return this.binaryCodec;
    }

    public TextCodec getTextCodec() {
        return this.textCodec;
    }

    public Codec<?, ?> getCodec(FieldFormat format) {
        switch (format) {
            case Text: {
                return this.textCodec;
            }
            case Binary: {
                return this.binaryCodec;
            }
        }
        throw new IllegalArgumentException();
    }

    public Modifiers.Parser getModifierParser() {
        return this.modifierParser;
    }

    public int getRelationId() {
        return this.relationId;
    }

    public Type unwrap() {
        return this;
    }

    public boolean isParameterFormatSupported(FieldFormat format) {
        return !Procs.isDefaultEncoder(((Codec)this.getCodec(format)).encoder);
    }

    public FieldFormat getParameterFormat() {
        FieldFormat other;
        if (this.category == Category.String) {
            return FieldFormat.Text;
        }
        if (this.isParameterFormatSupported(this.preferredParameterFormat)) {
            return this.preferredParameterFormat;
        }
        FieldFormat fieldFormat = other = this.preferredParameterFormat == FieldFormat.Binary ? FieldFormat.Text : FieldFormat.Binary;
        if (this.isParameterFormatSupported(other)) {
            return other;
        }
        throw new IllegalStateException("type has no supported parameter format: " + this.toString());
    }

    public boolean isResultFormatSupported(FieldFormat format) {
        return !Procs.isDefaultDecoder(((Codec)this.getCodec(format)).decoder);
    }

    public FieldFormat getResultFormat() {
        if (this.category == Category.String) {
            return FieldFormat.Text;
        }
        if (this.isResultFormatSupported(this.preferredResultFormat)) {
            return this.preferredResultFormat;
        }
        return this.preferredResultFormat == FieldFormat.Binary ? FieldFormat.Text : FieldFormat.Binary;
    }

    public void load(PGTypeTable.Row source, Registry registry) throws IOException {
        this.id = source.getOid();
        this.name = new QualifiedName(source.getNamespace(), source.getName());
        this.length = source.getLength() != -1 ? Short.valueOf(source.getLength()) : null;
        this.alignment = Type.getAlignment(source.getAlignment() != null ? Character.valueOf(source.getAlignment().charAt(0)) : null);
        this.category = Category.findValue(source.getCategory());
        this.delimeter = source.getDeliminator() != null ? Character.valueOf(source.getDeliminator().charAt(0)) : null;
        this.arrayTypeId = source.getArrayTypeId();
        this.relationId = source.getRelationId();
        this.textCodec = registry.getShared().loadTextCodec(source.getInputId(), source.getOutputId());
        this.binaryCodec = registry.getShared().loadBinaryCodec(source.getReceiveId(), source.getSendId());
        this.modifierParser = registry.getShared().loadModifierParser(source.getModInId());
        this.preferredParameterFormat = SystemSettings.PARAM_FORMAT_PREF.getSystem();
        this.preferredResultFormat = SystemSettings.FIELD_FORMAT_PREF.getSystem();
        if (!Procs.isDefaultDecoder(this.textCodec.getDecoder()) && !Procs.isDefaultDecoder(this.binaryCodec.getDecoder()) && this.textCodec.getDecoder().getDefaultClass() != this.binaryCodec.getDecoder().getDefaultClass()) {
            throw new IllegalArgumentException("Non default type decoders must have the same default class");
        }
    }

    private static Byte getAlignment(Character align) {
        if (align == null) {
            return null;
        }
        switch (align.charValue()) {
            case 'c': {
                return (byte)1;
            }
            case 's': {
                return (byte)2;
            }
            case 'i': {
                return (byte)4;
            }
            case 'd': {
                return (byte)8;
            }
        }
        throw new IllegalStateException("invalid alignment character: " + align);
    }

    public String toString() {
        return this.name.toString() + '(' + this.id + ')';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        return this.id == other.id;
    }

    public static class TextCodec
    extends Codec<CharSequence, StringBuilder> {
        public TextCodec(Codec.Decoder<CharSequence> decoder, Codec.Encoder<StringBuilder> encoder) {
            super(decoder, encoder);
        }
    }

    public static class BinaryCodec
    extends Codec<ByteBuf, ByteBuf> {
        public BinaryCodec(Codec.Decoder<ByteBuf> decoder, Codec.Encoder<ByteBuf> encoder) {
            super(decoder, encoder);
        }
    }

    public static class Codec<InBuffer, OutBuffer> {
        private Decoder<InBuffer> decoder;
        private Encoder<OutBuffer> encoder;

        public Codec(Decoder<InBuffer> decoder, Encoder<OutBuffer> encoder) {
            this.decoder = decoder;
            this.encoder = encoder;
        }

        public Encoder<OutBuffer> getEncoder() {
            return this.encoder;
        }

        public Decoder<InBuffer> getDecoder() {
            return this.decoder;
        }

        public static interface Encoder<OutBuffer> {
            public void encode(Context var1, Type var2, Object var3, Object var4, OutBuffer var5) throws IOException;
        }

        public static interface Decoder<InBuffer> {
            public Class<?> getDefaultClass();

            public Object decode(Context var1, Type var2, Short var3, Integer var4, InBuffer var5, Class<?> var6, Object var7) throws IOException;
        }
    }

    public static enum Category {
        Array('A'),
        Boolean('B'),
        Composite('C'),
        DateTime('D'),
        Enumeration('E'),
        Geometry('G'),
        NetworkAddress('I'),
        Numeric('N'),
        Psuedo('P'),
        Range('R'),
        String('S'),
        Timespan('T'),
        User('U'),
        BitString('V'),
        Unknown('X');

        private char id;

        private Category(char id) {
            this.id = id;
        }

        public char getId() {
            return this.id;
        }

        public static Category findValue(String id) {
            if (id == null || id.isEmpty()) {
                return null;
            }
            for (Category cat : Category.values()) {
                if (cat.id != id.charAt(0)) continue;
                return cat;
            }
            return null;
        }
    }
}

