/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.utils.ByteBufs;
import com.impossibl.postgres.utils.guava.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPipeline;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;

public class ProtocolChannel {
    private static final byte PASSWORD_MSG_ID = 112;
    private static final byte FLUSH_MSG_ID = 72;
    private static final byte TERMINATE_MSG_ID = 88;
    private static final byte SYNC_MSG_ID = 83;
    private static final byte QUERY_MSG_ID = 81;
    private static final byte PARSE_MSG_ID = 80;
    private static final byte BIND_MSG_ID = 66;
    private static final byte DESCRIBE_MSG_ID = 68;
    private static final byte EXECUTE_MSG_ID = 69;
    private static final byte CLOSE_MSG_ID = 67;
    private static final byte FUNCTION_CALL_MSG_ID = 70;
    private static final byte COPY_DONE_MSG_ID = 99;
    private static final byte COPY_FAIL_MSG_ID = 102;
    private static final byte COPY_DATA_MSG_ID = 100;
    private Channel channel;
    private ChannelOutboundInvoker flusher;
    private ByteBufAllocator alloc;
    private Charset charset;

    public ProtocolChannel(Channel channel, Charset charset) {
        this(channel, (ChannelOutboundInvoker)channel, charset);
    }

    public ProtocolChannel(Channel channel, ChannelOutboundInvoker flusher, Charset charset) {
        this.channel = channel;
        this.flusher = flusher;
        this.alloc = channel.alloc();
        this.charset = charset;
    }

    ChannelPipeline pipeline() {
        return this.channel.pipeline();
    }

    ProtocolChannel flush() {
        this.flusher.flush();
        return this;
    }

    ProtocolChannel writeSSLRequest() {
        ByteBuf msg = this.alloc.buffer();
        msg.writeInt(8);
        msg.writeInt(80877103);
        this.channel.write((Object)msg, this.channel.voidPromise());
        return this;
    }

    ProtocolChannel writeStartup(int protocolMajorVersion, int protocolMinorVersion, Map<String, Object> params) {
        ByteBuf msg = this.beginMessage((byte)0);
        msg.writeShort(protocolMajorVersion);
        msg.writeShort(protocolMinorVersion);
        for (Map.Entry<String, Object> paramEntry : params.entrySet()) {
            ByteBufs.writeCString(msg, paramEntry.getKey(), this.charset);
            ByteBufs.writeCString(msg, paramEntry.getValue().toString(), this.charset);
        }
        msg.writeByte(0);
        this.endMessage(msg);
        return this;
    }

    ProtocolChannel writePassword(String password) {
        ByteBuf msg = this.beginMessage((byte)112);
        ByteBufs.writeCString(msg, password, this.charset);
        this.endMessage(msg);
        return this;
    }

    ProtocolChannel writePassword(ByteBuf password) {
        ByteBuf msg = this.beginMessage((byte)112);
        msg.writeBytes(password);
        this.endMessage(msg);
        return this;
    }

    ProtocolChannel writeSCM(byte code) {
        ByteBuf msg = this.alloc.buffer(1);
        msg.writeByte((int)code);
        this.channel.write((Object)msg);
        return this;
    }

    ProtocolChannel writeQuery(String query) {
        ByteBuf msg = this.beginMessage((byte)81);
        ByteBufs.writeCString(msg, query, this.charset);
        this.endMessage(msg);
        return this;
    }

    ProtocolChannel writeParse(String stmtName, String query, TypeRef[] paramTypes) {
        ByteBuf msg = this.beginMessage((byte)80);
        ByteBufs.writeCString(msg, stmtName != null ? stmtName : "", this.charset);
        ByteBufs.writeCString(msg, query, this.charset);
        msg.writeShort(paramTypes.length);
        for (TypeRef paramType : paramTypes) {
            int paramTypeOid = paramType != null ? paramType.getOid() : 0;
            msg.writeInt(paramTypeOid);
        }
        this.endMessage(msg);
        return this;
    }

    private boolean isAllText(FieldFormatRef[] fieldFormats) {
        return fieldFormats.length == 1 && fieldFormats[0].getFormat() == FieldFormat.Text;
    }

    ProtocolChannel writeBind(String portalName, String stmtName, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers, FieldFormatRef[] resultFieldFormats) throws IOException {
        byte[] portalNameBytes = Strings.nullToEmpty(portalName).getBytes(this.charset);
        byte[] stmtNameBytes = Strings.nullToEmpty(stmtName).getBytes(this.charset);
        ByteBuf msg = this.beginMessage((byte)66);
        ByteBufs.writeCString(msg, portalNameBytes);
        ByteBufs.writeCString(msg, stmtNameBytes);
        this.loadParams(msg, parameterFormats, parameterBuffers);
        if (resultFieldFormats == null || resultFieldFormats.length == 0) {
            msg.writeShort(1);
            msg.writeShort(1);
        } else if (this.isAllText(resultFieldFormats)) {
            msg.writeShort(0);
        } else if (!this.isAllText(resultFieldFormats)) {
            msg.writeShort(resultFieldFormats.length);
            for (FieldFormatRef formatRef : resultFieldFormats) {
                msg.writeShort(formatRef.getFormat().ordinal());
            }
        }
        this.endMessage(msg);
        return this;
    }

    ProtocolChannel writeDescribe(ServerObjectType target, String targetName) {
        ByteBuf msg = this.beginMessage((byte)68);
        msg.writeByte((int)target.getId());
        ByteBufs.writeCString(msg, targetName != null ? targetName : "", this.charset);
        this.endMessage(msg);
        return this;
    }

    ProtocolChannel writeExecute(String portalName, int maxRows) {
        ByteBuf msg = this.beginMessage((byte)69);
        ByteBufs.writeCString(msg, portalName != null ? portalName : "", this.charset);
        msg.writeInt(maxRows);
        this.endMessage(msg);
        return this;
    }

    ProtocolChannel writeFunctionCall(int functionId, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers) throws IOException {
        ByteBuf msg = this.beginMessage((byte)70);
        msg.writeInt(functionId);
        this.loadParams(msg, parameterFormats, parameterBuffers);
        msg.writeShort(1);
        this.endMessage(msg);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    ProtocolChannel writeCopyData(InputStream stream) throws IOException {
        block8: {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    buffer = this.channel.pipeline().channel().alloc().buffer(4096);
                    try {
                        read = buffer.writeBytes(stream, buffer.capacity());
                        if (read >= 0) {
                            this.writeCopyData(buffer);
                        }
                        break block8;
                    }
                    finally {
                        buffer.release();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.writeCopyFail(e.getMessage());
                throw e;
            }
            ** GOTO lbl-1000
        }
        return this.writeCopyDone();
    }

    ProtocolChannel writeCopyData(ByteBuf data) throws IOException {
        ByteBuf msg = this.beginMessage((byte)100);
        msg.writeBytes(data);
        this.endMessage(msg);
        return this;
    }

    ProtocolChannel writeCopyDone() throws IOException {
        this.writeMessage((byte)99);
        return this;
    }

    ProtocolChannel writeCopyFail(String message) throws IOException {
        ByteBuf msg = this.beginMessage((byte)102);
        msg.writeCharSequence((CharSequence)message, this.charset);
        return this;
    }

    ProtocolChannel writeClose(ServerObjectType target, String targetName) {
        ByteBuf msg = this.beginMessage((byte)67);
        msg.writeByte((int)target.getId());
        ByteBufs.writeCString(msg, targetName != null ? targetName : "", this.charset);
        this.endMessage(msg);
        return this;
    }

    ProtocolChannel writeFlush() {
        this.writeMessage((byte)72);
        return this;
    }

    ProtocolChannel writeSync() {
        this.writeMessage((byte)83);
        return this;
    }

    ChannelFuture writeTerminate() {
        ByteBuf msg = this.alloc.buffer(5);
        msg.writeByte(88);
        msg.writeInt(4);
        return this.channel.writeAndFlush((Object)msg);
    }

    private void writeMessage(byte msgId) {
        ByteBuf msg = this.alloc.buffer(5);
        msg.writeByte((int)msgId);
        msg.writeInt(4);
        this.channel.write((Object)msg, this.channel.voidPromise());
    }

    private ByteBuf beginMessage(byte msgId) {
        ByteBuf msg = this.alloc.buffer();
        if (msgId != 0) {
            msg.writeByte((int)msgId);
        }
        msg.markWriterIndex();
        msg.writeInt(-1);
        return msg;
    }

    private void endMessage(ByteBuf msg) {
        int endPos = msg.writerIndex();
        msg.resetWriterIndex();
        int begPos = msg.writerIndex();
        msg.setInt(begPos, endPos - begPos);
        msg.writerIndex(endPos);
        this.channel.write((Object)msg, this.channel.voidPromise());
    }

    private void loadParams(ByteBuf msg, FieldFormatRef[] fieldFormats, ByteBuf[] paramBuffers) throws IOException {
        if (fieldFormats == null) {
            msg.writeShort(1);
            msg.writeShort(1);
        } else {
            msg.writeShort(fieldFormats.length);
            for (FieldFormatRef fieldFormatRef : fieldFormats) {
                FieldFormatRef fieldFormatRef2 = fieldFormatRef != null ? fieldFormatRef : FieldFormat.Text;
                msg.writeShort(fieldFormatRef2.getFormat().ordinal());
            }
        }
        if (paramBuffers == null) {
            msg.writeShort(0);
        } else {
            msg.writeShort(paramBuffers.length);
            for (FieldFormatRef fieldFormatRef : paramBuffers) {
                ByteBufs.lengthEncode(msg, fieldFormatRef, () -> ProtocolChannel.lambda$loadParams$0(msg, (ByteBuf)fieldFormatRef));
            }
        }
    }

    private static /* synthetic */ void lambda$loadParams$0(ByteBuf msg, ByteBuf paramBuffer) throws IOException {
        msg.writeBytes(paramBuffer);
        paramBuffer.resetReaderIndex();
    }
}

