/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.RowDataSet;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.BufferRowData;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.system.NoticeException;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ExecuteStatementRequest
implements ServerRequest {
    private String statementName;
    private String portalName;
    private FieldFormatRef[] parameterFormats;
    private ByteBuf[] parameterBuffers;
    private FieldFormatRef[] resultFieldFormats;
    private int maxRows;
    private RequestExecutor.ExecuteHandler handler;
    private RowDataSet rows;
    private List<Notice> notices;

    ExecuteStatementRequest(String statementName, String portalName, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers, FieldFormatRef[] resultFieldFormats, int maxRows, RequestExecutor.ExecuteHandler handler) {
        this.statementName = statementName;
        this.portalName = portalName;
        this.parameterFormats = parameterFormats;
        this.parameterBuffers = parameterBuffers;
        this.resultFieldFormats = resultFieldFormats;
        this.maxRows = maxRows;
        this.handler = handler;
        this.rows = new RowDataSet();
        this.notices = new ArrayList<Notice>();
    }

    private boolean isSynchronized() {
        return this.maxRows == 0;
    }

    @Override
    public ProtocolHandler createHandler() {
        return new Handler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeBind(this.portalName, this.statementName, this.parameterFormats, this.parameterBuffers, this.resultFieldFormats);
        channel.writeExecute(this.portalName, this.maxRows);
        if (!this.isSynchronized()) {
            channel.writeFlush();
        } else {
            channel.writeSync();
        }
        channel.flush();
    }

    private class Handler
    implements ProtocolHandler.BindComplete,
    ProtocolHandler.DataRow,
    ProtocolHandler.EmptyQuery,
    ProtocolHandler.PortalSuspended,
    ProtocolHandler.CommandComplete,
    ProtocolHandler.ReportNotice,
    ProtocolHandler.CommandError,
    ProtocolHandler.ReadyForQuery {
        private Handler() {
        }

        public String toString() {
            return "Execute Statement";
        }

        @Override
        public ProtocolHandler.Action notice(Notice notice) {
            ExecuteStatementRequest.this.notices.add(notice);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action bindComplete() {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action rowData(ByteBuf data) {
            ExecuteStatementRequest.this.rows.add(new BufferRowData(data.retain()));
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action portalSuspended() throws IOException {
            try {
                ExecuteStatementRequest.this.handler.handleSuspend(ExecuteStatementRequest.this.rows, ExecuteStatementRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release((Object)((Object)ExecuteStatementRequest.this.rows));
            }
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action emptyQuery() throws IOException {
            return this.commandComplete(null, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProtocolHandler.Action commandComplete(String command, Long rowsAffected, Long insertedOid) throws IOException {
            try {
                ExecuteStatementRequest.this.handler.handleComplete(command, rowsAffected, insertedOid, ExecuteStatementRequest.this.rows, ExecuteStatementRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release((Object)((Object)ExecuteStatementRequest.this.rows));
            }
            return ExecuteStatementRequest.this.isSynchronized() ? ProtocolHandler.Action.Resume : ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action error(Notice error) throws IOException {
            try {
                ExecuteStatementRequest.this.handler.handleError(new NoticeException(error), ExecuteStatementRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release((Object)((Object)ExecuteStatementRequest.this.rows));
            }
            return ExecuteStatementRequest.this.isSynchronized() ? ProtocolHandler.Action.Resume : ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action readyForQuery(TransactionStatus txnStatus) throws IOException {
            ExecuteStatementRequest.this.handler.handleReady(txnStatus);
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            try {
                ExecuteStatementRequest.this.handler.handleError(cause, ExecuteStatementRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release((Object)((Object)ExecuteStatementRequest.this.rows));
            }
        }
    }
}

