/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.JDBCTypeMapping;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGPreparedStatement;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.ResultBatches;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowData;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.Empty;
import com.impossibl.postgres.system.TypeMapContext;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.Nulls;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PGCallableStatement
extends PGPreparedStatement
implements CallableStatement {
    private String fullSqlText;
    private List<ParameterMode> allParameterModes;
    private Map<Integer, SQLType> outParameterSQLTypes;
    private ResultField[] outParameterFields;
    private RowData outParameterData;
    private Boolean nullFlag;
    private static final Map<Integer, Pattern> PARAM_REPLACE_REGEXES = new ConcurrentHashMap<Integer, Pattern>();
    private static final Pattern CLEANUP_LEADING_COMMAS_REGEX = Pattern.compile("\\(\\s*,+");
    private static final Pattern CLEANUP_MIDDLE_COMMAS_REGEX = Pattern.compile(",\\s*,");
    private static final Pattern CLEANUP_TAILING_COMMAS_REGEX = Pattern.compile(",+\\s*\\)");
    private static final ThreadLocal<TypeMapContext> TYPE_MAP_CONTEXTS = ThreadLocal.withInitial(TypeMapContext::new);

    PGCallableStatement(PGDirectConnection connection, int type, int concurrency, int holdability, String sqlText, int parameterCount, String cursorName, boolean hasAssign) throws SQLException {
        super(connection, type, concurrency, holdability, sqlText, 0, cursorName);
        this.fullSqlText = sqlText;
        this.allParameterModes = new ArrayList<Object>(Collections.nCopies(parameterCount, null));
        this.parameterTypes = Empty.EMPTY_TYPES;
        this.parameterFormats = Empty.EMPTY_FORMATS;
        this.parameterBuffers = Empty.EMPTY_BUFFERS;
        this.outParameterSQLTypes = new HashMap<Integer, SQLType>();
        this.outParameterFields = null;
        this.outParameterData = null;
        if (hasAssign) {
            this.allParameterModes.add(0, ParameterMode.Assign);
        }
    }

    @Override
    void internalClose() throws SQLException {
        super.internalClose();
        ReferenceCountUtil.release((Object)this.outParameterData);
        this.outParameterData = null;
    }

    @Override
    void verifyParameterSet() {
    }

    @Override
    void parseIfNeeded() throws SQLException {
        this.sqlText = this.fullSqlText;
        int reSeq = 1;
        for (int c = 0; c < this.allParameterModes.size(); ++c) {
            Matcher matcher = PGCallableStatement.getRegexForParameter(c + 1).matcher(this.sqlText);
            this.sqlText = this.allParameterModes.get(c) == ParameterMode.Out ? matcher.replaceFirst("$2") : matcher.replaceFirst("\\$" + reSeq++ + "$2");
        }
        this.sqlText = CLEANUP_LEADING_COMMAS_REGEX.matcher(this.sqlText).replaceAll("(");
        this.sqlText = CLEANUP_MIDDLE_COMMAS_REGEX.matcher(this.sqlText).replaceAll(",");
        this.sqlText = CLEANUP_TAILING_COMMAS_REGEX.matcher(this.sqlText).replaceAll(")");
        super.parseIfNeeded();
    }

    private static Pattern getRegexForParameter(int paramIndex) {
        Pattern pattern = PARAM_REPLACE_REGEXES.get(paramIndex);
        if (pattern == null) {
            pattern = Pattern.compile("\\s*\\$(" + paramIndex + ")\\s*([,)])");
            PARAM_REPLACE_REGEXES.put(paramIndex, pattern);
        }
        return pattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute() throws SQLException {
        this.resultBatches = ResultBatches.releaseAll(this.resultBatches);
        ReferenceCountUtil.release((Object)this.outParameterData);
        this.outParameterData = null;
        super.execute();
        if (!this.outParameterSQLTypes.isEmpty()) {
            if (this.resultBatches.isEmpty()) throw new SQLException("out parameters not returned");
            try (ResultBatch returnValuesBatch = (ResultBatch)this.resultBatches.remove(0);){
                if (returnValuesBatch.getFields().length != this.outParameterSQLTypes.size() || returnValuesBatch.borrowRows().size() > 1) {
                    throw new SQLException("incorrect number of out parameters");
                }
                if (!returnValuesBatch.isEmpty()) {
                    this.outParameterFields = returnValuesBatch.getFields();
                    this.outParameterData = returnValuesBatch.borrowRows().take(0);
                }
            }
        }
        if (this.resultBatches.isEmpty()) return false;
        ((ResultBatch)this.resultBatches.get(0)).clearRowsAffected();
        return false;
    }

    @Override
    public void clearParameters() throws SQLException {
        super.clearParameters();
        ReferenceCountUtil.release((Object)this.outParameterData);
        this.outParameterData = null;
    }

    private int mapToInParameterIndex(int parameterIdx) {
        int inParameterIdx = parameterIdx;
        for (int allParameterIdx = 1; allParameterIdx < this.allParameterModes.size() && allParameterIdx <= parameterIdx; ++allParameterIdx) {
            ParameterMode mode = this.allParameterModes.get(allParameterIdx - 1);
            if (mode != ParameterMode.Out && mode != ParameterMode.Assign) continue;
            --inParameterIdx;
        }
        return inParameterIdx;
    }

    private int mapToOutParameterIndex(int parameterIdx) throws SQLException {
        if (parameterIdx < 1 || parameterIdx > this.allParameterModes.size()) {
            throw Exceptions.PARAMETER_INDEX_OUT_OF_BOUNDS;
        }
        if (this.allParameterModes.get(parameterIdx - 1) == ParameterMode.In) {
            throw new SQLException("parameter not available");
        }
        int outParameterIdx = parameterIdx;
        for (int allParameterIdx = 1; allParameterIdx < this.allParameterModes.size() && allParameterIdx <= parameterIdx; ++allParameterIdx) {
            ParameterMode mode = this.allParameterModes.get(allParameterIdx - 1);
            if (mode != ParameterMode.In && mode != null) continue;
            --outParameterIdx;
        }
        return outParameterIdx;
    }

    private int mapFromOutParameterIndex(int outParameterIdx) {
        int parameterIdx = 0;
        for (int allParameterIdx = 1; allParameterIdx < this.allParameterModes.size() && allParameterIdx <= outParameterIdx; ++allParameterIdx) {
            if (this.allParameterModes.get(allParameterIdx - 1) != ParameterMode.In) continue;
            ++parameterIdx;
        }
        return parameterIdx;
    }

    private <R> R getVal(int parameterIdx, Class<R> targetClass, Object targetContext) throws SQLException {
        return targetClass.cast(this.getObj(parameterIdx, this.connection, targetClass, targetContext));
    }

    private Object getObj(int parameterIdx, Context context, Class<?> targetClass, Object targetContext) throws SQLException {
        Object val;
        Type type;
        int outParameterIdx = this.mapToOutParameterIndex(parameterIdx);
        --parameterIdx;
        --outParameterIdx;
        if (this.query == null) {
            throw new PGSQLSimpleException("statement not executed");
        }
        if (this.outParameterData == null) {
            throw new PGSQLSimpleException("No parameter results");
        }
        if (targetClass == null && (type = JDBCTypeMapping.getType(this.outParameterSQLTypes.get(parameterIdx), null, this.connection.getRegistry())) != null) {
            targetClass = type.getCodec(type.getResultFormat()).getDecoder().getDefaultClass();
        }
        try {
            val = this.outParameterData.getField(outParameterIdx, this.outParameterFields[outParameterIdx], context, targetClass, targetContext);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.nullFlag = val == null;
        return val;
    }

    @Override
    void set(int parameterIdx, Object val, SQLType targetSQLType) throws SQLException {
        this.set(parameterIdx, val, null, targetSQLType);
    }

    @Override
    void set(int parameterIdx, Object source, Object sourceContext, SQLType targetSQLType) throws SQLException {
        ParameterMode mode = this.allParameterModes.get(parameterIdx - 1);
        if (mode == ParameterMode.Out) {
            this.allParameterModes.set(parameterIdx - 1, ParameterMode.InOut);
        } else if (mode == null) {
            this.allParameterModes.set(parameterIdx - 1, ParameterMode.In);
        }
        parameterIdx = this.mapToInParameterIndex(parameterIdx);
        int needed = parameterIdx > this.parameterBuffers.length ? parameterIdx - this.parameterBuffers.length : 0;
        this.parameterTypes = Arrays.copyOf(this.parameterTypes, this.parameterTypes.length + needed);
        this.parameterTypesParsed = Arrays.copyOf(this.parameterTypes, this.parameterTypes.length + needed);
        Arrays.fill(this.parameterTypesParsed, this.connection.getRegistry().loadBaseType("text"));
        this.parameterFormats = Arrays.copyOf(this.parameterFormats, this.parameterFormats.length + needed);
        this.parameterBuffers = Arrays.copyOf(this.parameterBuffers, this.parameterBuffers.length + needed);
        super.set(parameterIdx, source, sourceContext, targetSQLType);
    }

    private int findParameter(String parameterName) throws SQLException {
        int idx;
        if (this.outParameterFields == null) {
            throw new PGSQLSimpleException("Unknown parameter name");
        }
        for (idx = 0; idx < this.outParameterFields.length && !this.outParameterFields[idx].getName().equalsIgnoreCase(parameterName); ++idx) {
        }
        if (idx == this.outParameterFields.length) {
            throw new PGSQLSimpleException("Unknown parameter name");
        }
        return this.mapFromOutParameterIndex(idx);
    }

    @Override
    boolean allowBatchSelects() {
        return true;
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        this.checkClosed();
        ParameterMode mode = this.allParameterModes.get(parameterIndex - 1);
        if (mode == ParameterMode.In) {
            this.allParameterModes.set(parameterIndex - 1, ParameterMode.InOut);
        } else if (mode == null) {
            this.allParameterModes.set(parameterIndex - 1, ParameterMode.Out);
        }
        this.outParameterSQLTypes.put(parameterIndex - 1, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, (SQLType)JDBCType.valueOf(sqlType), scale);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, Integer.MAX_VALUE);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, (SQLType)JDBCType.valueOf(sqlType));
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, JDBCTypeMapping.getSpecificSQLType(sqlType, typeName, this.connection));
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, (SQLType)JDBCType.valueOf(sqlType), typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        this.registerOutParameter(this.findParameter(parameterName), sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(parameterName, (SQLType)JDBCType.valueOf(sqlType));
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.findParameter(parameterName), sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterName, (SQLType)JDBCType.valueOf(sqlType), scale);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.findParameter(parameterName), sqlType, typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterName, (SQLType)JDBCType.valueOf(sqlType), typeName);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        if (this.nullFlag == null) {
            throw new SQLException("no column fetched");
        }
        return this.nullFlag;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, String.class, null);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        return Nulls.firstNonNull(this.getVal(parameterIndex, Boolean.class, null), true);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        return Nulls.firstNonNull(this.getVal(parameterIndex, Byte.class, null), (byte)0);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        return Nulls.firstNonNull(this.getVal(parameterIndex, Short.class, null), (short)0);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        return Nulls.firstNonNull(this.getVal(parameterIndex, Integer.class, null), 0);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        return Nulls.firstNonNull(this.getVal(parameterIndex, Long.class, null), 0L);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        return Nulls.firstNonNull(this.getVal(parameterIndex, Float.class, null), Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        return Nulls.firstNonNull(this.getVal(parameterIndex, Double.class, null), 0.0);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        return Nulls.firstNonNull(this.getVal(parameterIndex, BigDecimal.class, scale), BigDecimal.ZERO);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        return Nulls.firstNonNull(this.getVal(parameterIndex, BigDecimal.class, null), BigDecimal.ZERO);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, byte[].class, null);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getDate(parameterIndex, Calendar.getInstance());
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.getTime(parameterIndex, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getTimestamp(parameterIndex, Calendar.getInstance());
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, Date.class, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, Time.class, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, Timestamp.class, cal);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, Array.class, null);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, URL.class, null);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        String data = this.getString(parameterIndex);
        if (data == null) {
            return null;
        }
        return new StringReader(data);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, Blob.class, null);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, Clob.class, null);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, SQLXML.class, null);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.getObj(parameterIndex, this.connection, null, null);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        TypeMapContext context = TYPE_MAP_CONTEXTS.get();
        context.reset(this.connection, map);
        return this.getObj(parameterIndex, context, null, null);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, type, null);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.getVal(parameterIndex, RowId.class, null);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.getString(this.findParameter(parameterName));
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getBoolean(this.findParameter(parameterName));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.getByte(this.findParameter(parameterName));
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.getShort(this.findParameter(parameterName));
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.getInt(this.findParameter(parameterName));
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.getLong(this.findParameter(parameterName));
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.getFloat(this.findParameter(parameterName));
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.getDouble(this.findParameter(parameterName));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getBytes(this.findParameter(parameterName));
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.getDate(this.findParameter(parameterName));
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.getTime(this.findParameter(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getTimestamp(this.findParameter(parameterName));
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.findParameter(parameterName));
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getBigDecimal(this.findParameter(parameterName));
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findParameter(parameterName));
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.getRef(this.findParameter(parameterName));
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.getBlob(this.findParameter(parameterName));
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.getClob(this.findParameter(parameterName));
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.getArray(this.findParameter(parameterName));
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getDate(this.findParameter(parameterName));
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getTime(this.findParameter(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findParameter(parameterName));
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.getURL(this.findParameter(parameterName));
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return this.getRowId(this.findParameter(parameterName));
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getNClob(this.findParameter(parameterName));
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.getSQLXML(this.findParameter(parameterName));
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getNString(this.findParameter(parameterName));
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getNCharacterStream(this.findParameter(parameterName));
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(this.findParameter(parameterName));
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getObject(this.findParameter(parameterName), type);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.findParameter(parameterName), sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.findParameter(parameterName), x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.findParameter(parameterName), x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.findParameter(parameterName), x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.findParameter(parameterName), x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.findParameter(parameterName), x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.findParameter(parameterName), x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.findParameter(parameterName), x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.findParameter(parameterName), x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.findParameter(parameterName), x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.findParameter(parameterName), x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.findParameter(parameterName), x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.findParameter(parameterName), x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.findParameter(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.findParameter(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.findParameter(parameterName), x, length);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(this.findParameter(parameterName), x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(this.findParameter(parameterName), x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.findParameter(parameterName), x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.findParameter(parameterName), x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.findParameter(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.findParameter(parameterName), reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.findParameter(parameterName), x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.findParameter(parameterName), x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.findParameter(parameterName), x, cal);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.findParameter(parameterName), sqlType, typeName);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.setRowId(this.findParameter(parameterName), x);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setNString(this.findParameter(parameterName), value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setNCharacterStream(this.findParameter(parameterName), value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setNClob(this.findParameter(parameterName), value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.findParameter(parameterName), reader, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBlob(this.findParameter(parameterName), inputStream, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setNClob(this.findParameter(parameterName), reader, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlob(this.findParameter(parameterName), x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setClob(this.findParameter(parameterName), x);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.setSQLXML(this.findParameter(parameterName), xmlObject);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.setURL(this.findParameter(parameterName), val);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setAsciiStream(this.findParameter(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setBinaryStream(this.findParameter(parameterName), x, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(this.findParameter(parameterName), reader, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.setAsciiStream(this.findParameter(parameterName), x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.setBinaryStream(this.findParameter(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setCharacterStream(this.findParameter(parameterName), reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setNCharacterStream(this.findParameter(parameterName), value);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(this.findParameter(parameterName), reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setBlob(this.findParameter(parameterName), inputStream);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setNClob(this.findParameter(parameterName), reader);
    }

    private static enum ParameterMode {
        In,
        Out,
        InOut,
        Assign;

    }
}

