/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.internal;

import java.util.Objects;
import org.simantics.db.Resource;
import org.simantics.district.route.Route;
import org.simantics.district.route.Waypoint;

public class WaypointImpl
implements Waypoint {
    private Route owner;
    private final Resource element;
    private String label;

    public WaypointImpl(Resource element, String label) {
        Objects.requireNonNull(element, "Non-null element required");
        this.element = element;
        this.label = label;
    }

    @Override
    public Route owner() {
        return this.owner;
    }

    public WaypointImpl owner(Route route) {
        this.owner = route;
        return this;
    }

    @Override
    public <T> T getObject() {
        return (T)this.element;
    }

    @Override
    public <T> T adapt(Class<T> clazz) {
        if (clazz == Route.class) {
            return (T)this.owner;
        }
        if (clazz == Resource.class) {
            return (T)this.element;
        }
        if (clazz == String.class) {
            return (T)this.label;
        }
        return null;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return String.valueOf(this.label) + " " + this.element;
    }

    public Waypoint withLabel(String label) {
        return new WaypointImpl(this.element, label);
    }

    public int hashCode() {
        return Objects.hash(this.element);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WaypointImpl other = (WaypointImpl)obj;
        return Objects.equals(this.element, other.element);
    }
}

