/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.jface;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;



/**
 * Label provider for String[][] array
 * @author Toni Kalajainen
 */
public class StringArrayLabelProvider implements ITableLabelProvider, ILabelProvider {
    
    private final String data[][];
    
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();
    
    public StringArrayLabelProvider(String lines[][]) {
        this.data = lines;
    }
    
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String[] findLine(Object element) {
        for (int i=0; i<data.length; i++)
            if (data[i][0].equals(element))
                return data[i];
        return null;
    }
    
    public String getColumnText(Object element, int columnIndex) {                
        String line[] = (String[])element;
        if (line==null) return null;
        if (columnIndex>=line.length)
            return null;
        return line[columnIndex];
    }
    
    protected ILabelProviderListener[] getListeners() {
        return listeners.toArray(new ILabelProviderListener[0]);
    }

    public void addListener(ILabelProviderListener listener) {
        listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        listeners.remove(listener);
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return getColumnText(element, 0);
    }
    
    public void refreshAll() {
        LabelProviderChangedEvent e = new LabelProviderChangedEvent(this);
        for (ILabelProviderListener listener : getListeners())
            listener.labelProviderChanged(e);
    }
    
    public void elementChanged(Object ... element) {
        LabelProviderChangedEvent e = new LabelProviderChangedEvent(this, element);
        for (ILabelProviderListener listener : getListeners())
            listener.labelProviderChanged(e);
    }
    
}
