package org.simantics.spreadsheet.graph;

import org.simantics.simulator.toolkit.StandardNodeManager;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.spreadsheet.solver.SheetNode;
import org.simantics.spreadsheet.solver.SpreadsheetBook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("rawtypes")
public class SpreadsheetRealm extends StandardRealm<SheetNode,SpreadsheetBook> {

    private static final Logger LOGGER = LoggerFactory.getLogger(SpreadsheetRealm.class);

	SpreadsheetRealm(SpreadsheetBook book, String id) {
		super(book, id);
	}

	@Override
	protected StandardNodeManager<SheetNode, SpreadsheetBook> createManager() {
		return new SpreadsheetNodeManager(this);
	}

    @Override
    public Logger getLogger() {
        return LOGGER;
    }
    
}
