/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class FileIO {
    public static void moveFile(File source, File target) throws IOException {
        Files.move(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(File source, File target) throws IOException {
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void syncFile(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            raf.getFD().sync();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static File createTempDirectory(String prefix, File parent) throws IOException {
        if (parent != null) {
            return Files.createTempDirectory(parent.toPath(), prefix, new FileAttribute[0]).toFile();
        }
        return Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
    }
}

