package org.simantics.scl.reflection.functions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

import org.simantics.scl.runtime.function.FunctionImplN;

public class InstanceMethodFunction extends FunctionImplN {
    Method method;

    public InstanceMethodFunction(Method method) {
        super(method.getParameterTypes().length+1);
        this.method = method;
    }
    
    public Method getMethod() {
        return method;
    }

    @Override
    public Object doApply(Object... ps) {
        try {
            return method.invoke(ps[0], Arrays.copyOfRange(ps, 1, ps.length));
        } catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }
    
    @Override
    public String toString() {
        return method.getName();
    }
}
