/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.schema;

import org.simantics.objmap.backward.IBackwardLinkType;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.forward.IForwardLinkType;

/**
 * Contains rules for how a link should be created and maintained.
 * @author Hannu Niemist
 */
public interface ILinkType<Domain,Range> extends IBidirectionalMappingRule<Domain, Range>, IBackwardLinkType<Domain,Range>, IForwardLinkType<Domain,Range> {
    /**
     * Creates a domain element based on known range element.
     */
	//Resource createDomainElement(WriteGraph g, Object rangeElement) throws MappingException;
	
	/**
     * Creates a range element based on known domain element.
     */
	//Object createRangeElement(ReadGraph g, Resource domainElement) throws MappingException;
}
