/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.domain;

import java.util.Collection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;

/**
 * Accesses the set of objects attached to the element by the given relation.
 * @author Hannu Niemist
 */
public class RelatedOrderedSetElementsAccessor implements IDomainAccessor<Resource, Collection<Resource>> {

    static Logger LOGGER = LoggerFactory.getLogger(RelatedOrderedSetElementsAccessor.class);
    
	boolean deleteExtraObjects;

	public RelatedOrderedSetElementsAccessor(boolean deleteExtraObjects) {
        super();
        this.deleteExtraObjects = deleteExtraObjects;
    }

    @Override
	public Collection<Resource> get(ReadGraph g, Resource element) throws MappingException {
		try {
		    LOGGER.trace("        RelatedOrderedSetElementsAccessor.get");
			return OrderedSetUtils.toList(g, element);
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}
	}
	
	@Override
	public boolean set(WriteGraph g, Resource element, Collection<Resource> value)
			throws MappingException {
		try {
		    LOGGER.trace("        RelatedOrderedSetElementsAccessor.set");
		    return OrderedSetUtils.set(g, element, value);
		    // FIXME Implement deleteExtraObjects
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}
		
	}

}
