package org.simantics.objmap.graph.annotations;

/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum oy - initial API and implementation
 *******************************************************************************/

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.simantics.layer0.Layer0;
import org.simantics.objmap.graph.annotations.meta.IsFieldRule;

/**
 * This field is a java.util.List or an array type that represents the contents
 * of a Layer0.List entity that is the single object of the given relation. 
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@IsFieldRule
public @interface LinkedList {
	/**
	 * URI of a relation that has a Layer0.List as its object.
	 */
	String value();
	/**
	 * URI of the type of the list resource to create. 
	 */
	String type() default Layer0.URIs.List;
	boolean composition() default false;
}
