/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz.examples;

import org.simantics.graphviz.Edge;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.Graphs;
import org.simantics.graphviz.Node;

public class SimpleExample2 {

	public static final int COUNT = 1000;
	
	public static void main(String[] args) {
		Graph graph = new Graph();
		
		Node[] nodes = new Node[COUNT];
		
		for(int i=1;i<COUNT;++i)
			nodes[i] = new Node(graph, Integer.toString(i));
		
		for(int i=2;i<COUNT;++i) {
			int j = (i%2) == 1 ? i*3 + 1 : i/2;
			if(j < COUNT)
				new Edge(graph, nodes[i], nodes[j]);
		}
		
		Graphs.show(graph, "neato");
	}
	
}
