/*******************************************************************************
 * Copyright (c) 2007, 2021 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - hasChildren
 *******************************************************************************/
package org.simantics.browsing.ui.content;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;

/**
 * TODO: FIX THIS JAVADOC IT IS OUT-OF-DATE
 * 
 * A Viewpoint is used for describing the child node generation of a single UI
 * (e.g. tree) node. Viewpoints are created on a per UI node basis, including
 * the invisible root input of provided to
 * {@link GraphExplorer#setRoot(Object)}. Viewpoints are created by
 * {@link ViewpointFactory}s.
 * 
 * <p>
 * A Viewpoint is responsible for informing of any changes happening in the set
 * of children provided by it. Updates are performed using the
 * {@link PrimitiveQueryUpdater} received by the {@link ViewpointFactory} that
 * created the Viewpoint. To signal that the set of children has (possibly)
 * changed, invoke
 * {@link PrimitiveQueryUpdater#scheduleReplace(NodeContext, org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey, Object)}
 * and eventually the query system will re-request the viewpoint for the new
 * children.
 * </p>
 * 
 * @author Antti Villberg
 * 
 * @see ViewpointStub
 */
public interface ViewpointContribution {

    /**
     * Implementers can use this collection as a return value of
     * {@link #getContribution()} when the contribution implementation is
     * asynchronous and the real result will be updated later.
     * 
     * <p>
     * It is purposefully a different instance than {@link #NO_CONTRIBUTION}.
     */
    Collection<NodeContext> PENDING_CONTRIBUTION = Arrays.asList();

    /**
     * Return this from {@link #getContribution()} to indicate that no viewpoint
     * contributions are available.
     */
    Collection<NodeContext> NO_CONTRIBUTION      = Collections.emptyList();

    /**
     * @return a collection of contributions, must not be <code>null</code>
     */
    Collection<NodeContext> getContribution();

    /**
     * @return number of contributions
     */
    boolean hasChildren();

    /**
     * @return <code>null</code> if there is no tester
     */
    Tester getNodeContextTester();

    Class<?> getInputClass();
    
}
