/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.content;

/**
 * An interface for decorating aesthetic properties of an UI item, including the
 * label text, font, background color and foreground color.
 * 
 * @author Tuukka Lehtonen
 */
public interface LabelDecorator {

    /**
     * @param label the label before decoration
     * @param column the name of the UI column which the label is for
     * @param itemIndex the index of this label within its parenting
     *        INodeContext
     * @return the decorated label or <code>null</code> to denote
     *         <em>no decoration</em>
     */
    String decorateLabel(String label, String column, int itemIndex);

    <Color> Color decorateForeground(Color color, String column, int itemIndex);

    <Color> Color decorateBackground(Color color, String column, int itemIndex);

    /**
     * @param font <code>null</code> if no default font is set ??
     * @param column the name of the UI column which the label is for
     * @param itemIndex the index of this label within its parenting
     *        INodeContext
     * @return the decorated font instance or <code>null</code> to indicate
     *         "no decoration"
     */
    <Font> Font decorateFont(Font font, String column, int itemIndex);


    /**
     * Stub for simpler implementation of a LabelDecorator.
     */
    public static class Stub implements LabelDecorator {
        @Override
        public <Color> Color decorateBackground(Color color, String column, int itemIndex) {
            return null;
        }

        @Override
        public <Font> Font decorateFont(Font font, String column, int itemIndex) {
            return null;
        }

        @Override
        public <Color> Color decorateForeground(Color color, String column, int itemIndex) {
            return null;
        }

        @Override
        public String decorateLabel(String label, String column, int itemIndex) {
            return null;
        }
    }

}
