package org.simantics.browsing.ui.content;

import java.util.Collection;

public class CompositeLabelDecorator implements LabelDecorator {

    Collection<LabelDecorator> decorators;
    
    public static final LabelDecorator ID = new LabelDecorator() {

        @Override
        public String decorateLabel(String label, String column, int itemIndex) {
            return label;
        }

        @Override
        public <Color> Color decorateForeground(Color color, String column,
                int itemIndex) {
            return color;
        }

        @Override
        public <Color> Color decorateBackground(Color color, String column,
                int itemIndex) {
            return color;
        }

        @Override
        public <Font> Font decorateFont(Font font, String column, int itemIndex) {
            return font;
        }
        
    };
    
    private CompositeLabelDecorator(Collection<LabelDecorator> decorators) {
        this.decorators = decorators;
    }
    
    public static LabelDecorator create(Collection<LabelDecorator> decorators) {
        if(decorators.isEmpty())
            return ID;
        else if(decorators.size() == 1)
            return decorators.iterator().next();
        else
            return new CompositeLabelDecorator(decorators);
    }

    @Override
    public String decorateLabel(String label, String column, int itemIndex) {
        for(LabelDecorator decorator : decorators) {
            String dlabel = decorator.decorateLabel(label, column, itemIndex);
            if(dlabel != null)
                label = dlabel;
        }
        return label;
    }

    @Override
    public <Color> Color decorateForeground(Color color, String column,
            int itemIndex) {
        for(LabelDecorator decorator : decorators) {
            Color dcolor = decorator.decorateForeground(color, column, itemIndex);
            if (dcolor != null)
                color = dcolor;
        }
        return color;
    }

    @Override
    public <Color> Color decorateBackground(Color color, String column,
            int itemIndex) {
        for(LabelDecorator decorator : decorators) {
            Color dcolor = decorator.decorateBackground(color, column, itemIndex);
            if (dcolor != null)
                color = dcolor;
        }
        return color;
    }

    @Override
    public <Font> Font decorateFont(Font font, String column, int itemIndex) {
        for(LabelDecorator decorator : decorators) {
            Font dfont = decorator.decorateFont(font, column, itemIndex);
            if (dfont != null)
                font = dfont;
        }
        return font;
    }

}
