/*******************************************************************************
 * Copyright (c) 2021 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.content.ViewpointContribution;

public class DefaultHasChildrenProcessor extends AbstractNodeQueryProcessor<Boolean> {

    @Override
    public QueryKey<Boolean> getIdentifier() {
        return BuiltinKeys.HAS_CHILDREN;
    }

    @Override
    public Boolean query(NodeQueryManager manager, NodeContext context) {

        Collection<ViewpointContribution> contributions = manager.query(context, BuiltinKeys.VIEWPOINT_CONTRIBUTIONS);
        if (contributions == null)
            return false;

        for (ViewpointContribution contribution : contributions) {
            Class<?> clazz = contribution.getInputClass();
            if (clazz.isInstance(context.getConstant(BuiltinKeys.INPUT))) {
                Tester test = contribution.getNodeContextTester();
                if (test == null || test.test(manager, context)) {
                    if (contribution.hasChildren())
                        return true;
                }
            }
        }

        return false;

    }

    @Override
    public String toString() {
        return "HasChildrenProcessor";
    }

}