/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.node;

import org.simantics.browsing.ui.common.Activator;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.imagers.ImageURLs;
import org.simantics.browsing.ui.common.imagers.SingleImageURLs;


public abstract class LibraryNode<T> extends AbstractNode<T> {

	public LibraryNode(T data) {
		super(data);
	}

	@Override
	protected ImageURLs getImageURLs() {
		return new SingleImageURLs(ColumnKeys.SINGLE, Activator.getDefaultResource("icons/folder.png"));
	}
	
}
