/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.node;

import java.util.Map;

public class ConstantInput<ImageDescriptor> {

	final public int category;
	final public Map<String, String> labels;
	final public Map<String, ImageDescriptor> imageDescriptors;

	public ConstantInput(Map<String, String> labels, Map<String, ImageDescriptor> imageDescriptors, int category) {
		this.category = category;
		this.labels = labels;
		this.imageDescriptors = imageDescriptors;
	}

	public Map<String, ImageDescriptor> getImageDescriptors() {
		return imageDescriptors;
	}
	
	public Map<String, String> getLabels() {
		return labels;
	}

	public int getCategory() {
		return category;
	}

}
