/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.internal;

import java.util.TreeSet;

/**
 * A wrapper Comparable class for allowing the creation of "multisets" with the
 * basic {@link TreeSet} implementation.
 * 
 * <p>
 * This class will define the {@link Comparable#compareTo(Object)} method in
 * such a way that the result will only be 0 if both the wrapped object and the
 * {@link #orderNumber} argument match.
 * 
 * @author Tuukka Lehtonen
 */
public class ComparableWrapper<T extends Comparable<T>> implements Comparable<ComparableWrapper<T>> {
    public final T   t;
    public final int orderNumber;

    public ComparableWrapper(T t, int orderNumber) {
        assert t != null;
        this.t = t;
        this.orderNumber = orderNumber;
    }

    @Override
    public int compareTo(ComparableWrapper<T> o) {
        int result = t.compareTo(o.t);
        return result != 0 ? result : (orderNumber - o.orderNumber);
    }
}
