/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.extension.internal;

import org.simantics.browsing.ui.common.extension.EvaluatorFactory;




public class EvaluatorFactoryExtension implements IEvaluatorFactoryExtension {

    final private EvaluatorFactory factory;
    
    public EvaluatorFactoryExtension(EvaluatorFactory factory) {
        this.factory = factory;
    }
    
    @Override
    public Class<?> clazz() {
        return factory.getClazz();
    }

    @Override
    public EvaluatorFactory factory() {
        return factory;
    }

}
