/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.comparators;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.ComparableContext;

public abstract class ImmutableLexicalComparable implements ComparableContext {

    protected final int         category;
    protected final String      label;
    protected final NodeContext context;

    public ImmutableLexicalComparable(int category, String label, NodeContext context) {
        this.category = category;
        this.label = label;
        this.context = context;
    }

    public int getCategory() {
        return category;
    }

    public String getLabel() {
        return label;
    }

    @Override
    public NodeContext getContext() {
        return context;
    }

}

