package org.simantics.backup;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;

/**
 * @author Tuukka Lehtonen
 */
public class Backups {

    /**
     * 
     * @param providers
     * @throws BackupException
     */
    public static void lock(List<IBackupProvider> providers) throws BackupException {
        int i = 0;
        int count = providers.size();
        try {
            for (; i < count; ++i) {
                providers.get(i).lock();
            }
        } catch (BackupException e) {
            for (int j = i-1; j >= 0; --j) {
                try {
                    providers.get(j).unlock();
                } catch (BackupException ex) {
                    // TODO: proper logging.
                    ex.printStackTrace();
                }
            }
            throw e;
        }
    }

    public static List<Future<BackupException>> syncBackup(List<IBackupProvider> providers, Path targetPath, int revision) throws BackupException {
        // Initiate all backup providers, possibly to execute concurrently.
        List<Future<BackupException>> futures = new ArrayList<>(providers.size());
        for (IBackupProvider provider : providers)
            futures.add( provider.backup(targetPath, revision) );

        return futures;
    }

    public static void unlock(Collection<IBackupProvider> providers) {
        for (IBackupProvider provider : providers) {
            try {
                provider.unlock();
            } catch (BackupException e) {
                // TODO: proper logging
                e.printStackTrace();
            }
        }
    }

//    private static class BackupResultFuture implements Future<BackupException> {
//
//        public static final BackupResultFuture SUCCESS = new BackupResultFuture(null);
//
//        private final BackupException e;
//
//        public BackupResultFuture(BackupException e) {
//            this.e = e;
//        }
//
//        @Override
//        public boolean cancel(boolean mayInterruptIfRunning) {
//            return false;
//        }
//
//        @Override
//        public boolean isCancelled() {
//            return false;
//        }
//
//        @Override
//        public boolean isDone() {
//            return true;
//        }
//
//        @Override
//        public BackupException get() throws InterruptedException, ExecutionException {
//            return e;
//        }
//
//        @Override
//        public BackupException get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
//            return e;
//        }
//
//    }

}
