package org.simantics.databoard.tests;

import java.lang.reflect.Field;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.reflection.BindingRequest;

public class TestInterfaceBinding {

	public interface Tuple {
		   int length();
		   Object get(int id);
		   Object[] toArray();
	}
	
	public static class MyTestClass {
		public List<Tuple> dummy;
	}
	
	public static void main(String[] args) {
		try {
			Binding b2 = Bindings.getBinding( Tuple.class );
			Field f = MyTestClass.class.getField("dummy");
			Binding b = Bindings.getBinding( BindingRequest.create(f) );
			b.createDefault();
		} catch (BindingConstructionException e) {
			e.printStackTrace();
		} catch (BindingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchFieldException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
}
