/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.chr;

import org.simantics.scl.runtime.chr.CHRContext;

public abstract class CHRPriority
implements Comparable<CHRPriority> {
    public final int priority;
    private CHRPriority sibling;
    private CHRPriority child;
    boolean inContext;

    public CHRPriority(int priority) {
        this.priority = priority;
    }

    public static CHRPriority merge(CHRPriority a, CHRPriority b) {
        if (a.priority <= b.priority) {
            a.sibling = null;
            b.sibling = a.child;
            a.child = b;
            return a;
        }
        a.sibling = b.child;
        b.sibling = null;
        b.child = a;
        return b;
    }

    protected void ensureInContext(CHRContext context) {
        if (!this.inContext) {
            CHRPriority topPriority = context.topPriority;
            context.topPriority = topPriority == null ? this : CHRPriority.merge(topPriority, this);
            this.inContext = true;
        }
    }

    private CHRPriority mergeSiblings() {
        if (this.sibling == null) {
            return this;
        }
        CHRPriority nextSibling = this.sibling.sibling;
        CHRPriority merged = CHRPriority.merge(this, this.sibling);
        if (nextSibling == null) {
            return merged;
        }
        return CHRPriority.merge(merged, nextSibling.mergeSiblings());
    }

    public CHRPriority nextPriority() {
        if (this.child == null) {
            return null;
        }
        CHRPriority result = this.child.mergeSiblings();
        this.child = null;
        return result;
    }

    @Override
    public int compareTo(CHRPriority o) {
        return Double.compare(this.priority, o.priority);
    }

    public abstract void activate(CHRContext var1);
}

