/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Calendar;
import org.simantics.utils.datastructures.TypeCastException;

public class ValueUtils {
    static final Boolean True = new Boolean(true);
    static final Boolean False = new Boolean(false);

    public static Number doubleToNumberClass(double value, Class<? extends Number> numberClass) throws ClassCastException {
        if (numberClass == Integer.class) {
            return (int)value;
        }
        if (numberClass == Byte.class) {
            return (byte)value;
        }
        if (numberClass == Float.class) {
            return Float.valueOf((float)value);
        }
        if (numberClass == Short.class) {
            return (short)value;
        }
        if (numberClass == Long.class) {
            return (long)value;
        }
        if (numberClass == Double.class) {
            return value;
        }
        throw new ClassCastException("Cannot convert to " + numberClass.getName());
    }

    public static void serialize(DataOutput stream, Object obj) throws IOException {
        block24: {
            try {
                Class<?> clazz = obj.getClass();
                if (clazz.isArray()) {
                    if (obj instanceof double[]) {
                        double[] array = (double[])obj;
                        stream.writeByte(16);
                        stream.writeInt(array.length);
                        double[] dArray = array;
                        int n = array.length;
                        int n2 = 0;
                        while (n2 < n) {
                            double v = dArray[n2];
                            stream.writeDouble(v);
                            ++n2;
                        }
                        break block24;
                    }
                    if (obj instanceof float[]) {
                        float[] array = (float[])obj;
                        stream.writeByte(15);
                        stream.writeInt(array.length);
                        float[] fArray = array;
                        int n = array.length;
                        int n3 = 0;
                        while (n3 < n) {
                            float v = fArray[n3];
                            stream.writeFloat(v);
                            ++n3;
                        }
                        break block24;
                    }
                    if (obj instanceof int[]) {
                        int[] array = (int[])obj;
                        stream.writeByte(13);
                        stream.writeInt(array.length);
                        int[] nArray = array;
                        int n = array.length;
                        int n4 = 0;
                        while (n4 < n) {
                            int v = nArray[n4];
                            stream.writeInt(v);
                            ++n4;
                        }
                        break block24;
                    }
                    if (obj instanceof String[]) {
                        String[] array = (String[])obj;
                        stream.writeByte(17);
                        stream.writeInt(array.length);
                        String[] stringArray = array;
                        int n = array.length;
                        int n5 = 0;
                        while (n5 < n) {
                            String v = stringArray[n5];
                            stream.writeUTF(v);
                            ++n5;
                        }
                        break block24;
                    }
                    if (obj instanceof boolean[]) {
                        boolean[] array = (boolean[])obj;
                        stream.writeByte(11);
                        stream.writeInt(array.length);
                        boolean[] blArray = array;
                        int n = array.length;
                        int n6 = 0;
                        while (n6 < n) {
                            boolean v = blArray[n6];
                            stream.writeByte(v ? 1 : 0);
                            ++n6;
                        }
                        break block24;
                    }
                    if (obj instanceof byte[]) {
                        byte[] array = (byte[])obj;
                        stream.writeByte(12);
                        stream.writeInt(array.length);
                        byte[] byArray = array;
                        int n = array.length;
                        int n7 = 0;
                        while (n7 < n) {
                            byte v = byArray[n7];
                            stream.writeByte(v);
                            ++n7;
                        }
                        break block24;
                    }
                    if (obj instanceof long[]) {
                        long[] array = (long[])obj;
                        stream.writeByte(14);
                        stream.writeInt(array.length);
                        long[] lArray = array;
                        int n = array.length;
                        int n8 = 0;
                        while (n8 < n) {
                            long v = lArray[n8];
                            stream.writeLong(v);
                            ++n8;
                        }
                        break block24;
                    }
                    System.out.println("ValueUtils.serialize failed (invalid type).");
                    throw new InvalidParameterException();
                }
                if (clazz == Double.class) {
                    stream.writeByte(6);
                    stream.writeDouble((Double)obj);
                    break block24;
                }
                if (clazz == Float.class) {
                    stream.writeByte(5);
                    stream.writeDouble(((Float)obj).floatValue());
                    break block24;
                }
                if (clazz == Integer.class) {
                    stream.writeByte(3);
                    stream.writeInt((Integer)obj);
                    break block24;
                }
                if (clazz == String.class) {
                    stream.writeByte(7);
                    stream.writeUTF((String)obj);
                    break block24;
                }
                if (clazz == Boolean.class) {
                    stream.writeByte((Boolean)obj != false ? 1 : 0);
                    break block24;
                }
                if (clazz == Byte.class) {
                    stream.writeByte(2);
                    stream.writeByte(((Byte)obj).byteValue());
                    break block24;
                }
                if (clazz == Long.class) {
                    stream.writeByte(4);
                    stream.writeLong((Long)obj);
                    break block24;
                }
                System.out.println("ValueUtils.serialize failed (invalid type).");
                throw new InvalidParameterException();
            }
            catch (IOException e) {
                System.out.println("ValueUtils.serialize failed (write failure).");
                e.printStackTrace();
                throw e;
            }
        }
    }

    public static Object deserialize(DataInput stream) throws IOException {
        try {
            byte typeCode = stream.readByte();
            switch (typeCode) {
                case 0: {
                    return False;
                }
                case 1: {
                    return True;
                }
                case 2: {
                    return stream.readByte();
                }
                case 3: {
                    return stream.readInt();
                }
                case 4: {
                    return stream.readLong();
                }
                case 5: {
                    return Float.valueOf(stream.readFloat());
                }
                case 6: {
                    return stream.readDouble();
                }
                case 7: {
                    return stream.readUTF();
                }
                case 11: {
                    int length = stream.readInt();
                    boolean[] value = new boolean[length];
                    int i = 0;
                    while (i < length) {
                        value[i] = stream.readByte() != 0;
                        ++i;
                    }
                    return value;
                }
                case 12: {
                    int length = stream.readInt();
                    byte[] value = new byte[length];
                    int i = 0;
                    while (i < length) {
                        value[i] = stream.readByte();
                        ++i;
                    }
                    return value;
                }
                case 13: {
                    int length = stream.readInt();
                    int[] value = new int[length];
                    int i = 0;
                    while (i < length) {
                        value[i] = stream.readInt();
                        ++i;
                    }
                    return value;
                }
                case 14: {
                    int length = stream.readInt();
                    long[] value = new long[length];
                    int i = 0;
                    while (i < length) {
                        value[i] = stream.readLong();
                        ++i;
                    }
                    return value;
                }
                case 15: {
                    int length = stream.readInt();
                    float[] value = new float[length];
                    int i = 0;
                    while (i < length) {
                        value[i] = stream.readFloat();
                        ++i;
                    }
                    return value;
                }
                case 16: {
                    int length = stream.readInt();
                    double[] value = new double[length];
                    int i = 0;
                    while (i < length) {
                        value[i] = stream.readDouble();
                        ++i;
                    }
                    return value;
                }
                case 17: {
                    int length = stream.readInt();
                    String[] value = new String[length];
                    int i = 0;
                    while (i < length) {
                        value[i] = stream.readUTF();
                        ++i;
                    }
                    return value;
                }
            }
            System.out.println("ValueUtils.deserialize failed (invalid type code).");
            throw new IOException("Invalid value data.");
        }
        catch (IOException e) {
            System.out.println("ValueUtils.deserialize failed (reading failure).");
            e.printStackTrace();
            throw e;
        }
    }

    public static boolean isArray(Object obj) {
        return obj.getClass().isArray();
    }

    public static int getArrayLength(Object obj) {
        return Array.getLength(obj);
    }

    public static double[] toDoubleArray(Object obj) throws TypeCastException {
        if (!ValueUtils.isArray(obj)) {
            double scalar = ValueUtils.toDoubleScalar(obj);
            return new double[]{scalar};
        }
        int len = ValueUtils.getArrayLength(obj);
        double[] result = new double[len];
        if (obj instanceof Calendar[]) {
            Calendar[] array = (Calendar[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].getTimeInMillis();
                ++i;
            }
            return result;
        }
        if (obj instanceof Integer[]) {
            Integer[] array = (Integer[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].doubleValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof int[]) {
            int[] array = (int[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Double[]) {
            Double[] array = (Double[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof double[]) {
            return (double[])obj;
        }
        if (obj instanceof Float[]) {
            Float[] array = (Float[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].doubleValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof float[]) {
            float[] array = (float[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Long[]) {
            Long[] array = (Long[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].doubleValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof long[]) {
            long[] array = (long[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Short[]) {
            Short[] array = (Short[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].doubleValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof short[]) {
            short[] array = (short[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Byte[]) {
            Byte[] array = (Byte[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].doubleValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof String[]) {
            String[] array = (String[])obj;
            int i = 0;
            while (i < len) {
                try {
                    result[i] = new Double(array[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TypeCastException(obj.getClass());
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof Boolean[]) {
            Boolean[] array = (Boolean[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i] != false ? 1 : 0;
                ++i;
            }
            return result;
        }
        if (obj instanceof boolean[]) {
            boolean[] array = (boolean[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i] ? 1 : 0;
                ++i;
            }
            return result;
        }
        throw new TypeCastException(obj.getClass());
    }

    public static double toDoubleScalar(Object obj) throws TypeCastException {
        if (!ValueUtils.isArray(obj)) {
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            if (obj instanceof Calendar) {
                return ((Calendar)obj).getTimeInMillis();
            }
            if (obj instanceof String) {
                String str = (String)obj;
                try {
                    Double d = new Double(str);
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TypeCastException(obj.getClass());
                }
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1 : 0;
            }
            throw new TypeCastException(obj.getClass());
        }
        int len = ValueUtils.getArrayLength(obj);
        if (len != 1) {
            throw new TypeCastException("Expected length of array is 1");
        }
        if (obj instanceof double[]) {
            return ((double[])obj)[0];
        }
        if (obj instanceof int[]) {
            int[] array = (int[])obj;
            return array[0];
        }
        if (obj instanceof Calendar[]) {
            Calendar[] array = (Calendar[])obj;
            return array[0].getTimeInMillis();
        }
        if (obj instanceof Integer[]) {
            Integer[] array = (Integer[])obj;
            return array[0].doubleValue();
        }
        if (obj instanceof Double[]) {
            Double[] array = (Double[])obj;
            return array[0];
        }
        if (obj instanceof Float[]) {
            Float[] array = (Float[])obj;
            return array[0].doubleValue();
        }
        if (obj instanceof float[]) {
            float[] array = (float[])obj;
            return array[0];
        }
        if (obj instanceof Long[]) {
            Long[] array = (Long[])obj;
            return array[0].doubleValue();
        }
        if (obj instanceof long[]) {
            long[] array = (long[])obj;
            return array[0];
        }
        if (obj instanceof Short[]) {
            Short[] array = (Short[])obj;
            return array[0].doubleValue();
        }
        if (obj instanceof short[]) {
            short[] array = (short[])obj;
            return array[0];
        }
        if (obj instanceof Byte[]) {
            Byte[] array = (Byte[])obj;
            return array[0].doubleValue();
        }
        if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            return array[0];
        }
        if (obj instanceof String[]) {
            String[] array = (String[])obj;
            try {
                return new Double(array[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TypeCastException(obj.getClass());
            }
        }
        if (obj instanceof Boolean[]) {
            Boolean[] array = (Boolean[])obj;
            return array[0] != false ? 1 : 0;
        }
        if (obj instanceof boolean[]) {
            boolean[] array = (boolean[])obj;
            return array[0] ? 1 : 0;
        }
        throw new TypeCastException(obj.getClass());
    }

    public static float[] toFloatArray(Object obj) throws TypeCastException {
        if (!ValueUtils.isArray(obj)) {
            float scalar = ValueUtils.toFloatScalar(obj);
            return new float[]{scalar};
        }
        int len = ValueUtils.getArrayLength(obj);
        float[] result = new float[len];
        if (obj instanceof Calendar[]) {
            Calendar[] array = (Calendar[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].getTimeInMillis();
                ++i;
            }
            return result;
        }
        if (obj instanceof Integer[]) {
            Integer[] array = (Integer[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].floatValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof int[]) {
            int[] array = (int[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Float[]) {
            Float[] array = (Float[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].floatValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof float[]) {
            return (float[])obj;
        }
        if (obj instanceof Double[]) {
            Double[] array = (Double[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].floatValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof double[]) {
            double[] array = (double[])obj;
            int i = 0;
            while (i < len) {
                result[i] = (float)array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Long[]) {
            Long[] array = (Long[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].floatValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof long[]) {
            long[] array = (long[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Short[]) {
            Short[] array = (Short[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].floatValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof short[]) {
            short[] array = (short[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Byte[]) {
            Byte[] array = (Byte[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].floatValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof String[]) {
            String[] array = (String[])obj;
            int i = 0;
            while (i < len) {
                try {
                    result[i] = new Float(array[i]).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TypeCastException(obj.getClass());
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof Boolean[]) {
            Boolean[] array = (Boolean[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i] != false ? 1 : 0;
                ++i;
            }
            return result;
        }
        if (obj instanceof boolean[]) {
            boolean[] array = (boolean[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i] ? 1 : 0;
                ++i;
            }
            return result;
        }
        throw new TypeCastException(obj.getClass());
    }

    public static float toFloatScalar(Object obj) throws TypeCastException {
        if (!ValueUtils.isArray(obj)) {
            if (obj instanceof Number) {
                return ((Number)obj).floatValue();
            }
            if (obj instanceof Calendar) {
                return ((Calendar)obj).getTimeInMillis();
            }
            if (obj instanceof String) {
                String str = (String)obj;
                try {
                    Float d = new Float(str);
                    return d.floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TypeCastException(obj.getClass());
                }
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1 : 0;
            }
            throw new TypeCastException(obj.getClass());
        }
        int len = ValueUtils.getArrayLength(obj);
        if (len != 1) {
            throw new TypeCastException("Expected length of array is 1");
        }
        if (obj instanceof float[]) {
            return ((float[])obj)[0];
        }
        if (obj instanceof int[]) {
            int[] array = (int[])obj;
            return array[0];
        }
        if (obj instanceof Calendar[]) {
            Calendar[] array = (Calendar[])obj;
            return array[0].getTimeInMillis();
        }
        if (obj instanceof Integer[]) {
            Integer[] array = (Integer[])obj;
            return array[0].floatValue();
        }
        if (obj instanceof Float[]) {
            Float[] array = (Float[])obj;
            return array[0].floatValue();
        }
        if (obj instanceof Float[]) {
            Float[] array = (Float[])obj;
            return array[0].floatValue();
        }
        if (obj instanceof double[]) {
            double[] array = (double[])obj;
            return (float)array[0];
        }
        if (obj instanceof Long[]) {
            Long[] array = (Long[])obj;
            return array[0].floatValue();
        }
        if (obj instanceof long[]) {
            long[] array = (long[])obj;
            return array[0];
        }
        if (obj instanceof Short[]) {
            Short[] array = (Short[])obj;
            return array[0].floatValue();
        }
        if (obj instanceof short[]) {
            short[] array = (short[])obj;
            return array[0];
        }
        if (obj instanceof Byte[]) {
            Byte[] array = (Byte[])obj;
            return array[0].floatValue();
        }
        if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            return array[0];
        }
        if (obj instanceof String[]) {
            String[] array = (String[])obj;
            try {
                return new Float(array[0]).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new TypeCastException(obj.getClass());
            }
        }
        if (obj instanceof Boolean[]) {
            Boolean[] array = (Boolean[])obj;
            return array[0] != false ? 1 : 0;
        }
        if (obj instanceof boolean[]) {
            boolean[] array = (boolean[])obj;
            return array[0] ? 1 : 0;
        }
        throw new TypeCastException(obj.getClass());
    }

    public static long toLongScalar(Object obj) throws TypeCastException {
        if (!ValueUtils.isArray(obj)) {
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            if (obj instanceof Calendar) {
                return ((Calendar)obj).getTimeInMillis();
            }
            if (obj instanceof String) {
                String str = (String)obj;
                try {
                    Long d = new Long(str);
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TypeCastException(obj.getClass());
                }
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1 : 0;
            }
            throw new TypeCastException(obj.getClass());
        }
        int len = ValueUtils.getArrayLength(obj);
        if (len != 1) {
            throw new TypeCastException("Expected length of array is 1");
        }
        if (obj instanceof double[]) {
            return ((long[])obj)[0];
        }
        if (obj instanceof int[]) {
            int[] array = (int[])obj;
            return array[0];
        }
        if (obj instanceof Calendar[]) {
            Calendar[] array = (Calendar[])obj;
            return array[0].getTimeInMillis();
        }
        if (obj instanceof Integer[]) {
            Integer[] array = (Integer[])obj;
            return array[0].longValue();
        }
        if (obj instanceof Double[]) {
            Double[] array = (Double[])obj;
            return array[0].longValue();
        }
        if (obj instanceof Float[]) {
            Float[] array = (Float[])obj;
            return array[0].longValue();
        }
        if (obj instanceof float[]) {
            float[] array = (float[])obj;
            return (long)array[0];
        }
        if (obj instanceof Long[]) {
            Long[] array = (Long[])obj;
            return array[0];
        }
        if (obj instanceof long[]) {
            long[] array = (long[])obj;
            return array[0];
        }
        if (obj instanceof Short[]) {
            Short[] array = (Short[])obj;
            return array[0].longValue();
        }
        if (obj instanceof short[]) {
            short[] array = (short[])obj;
            return array[0];
        }
        if (obj instanceof Byte[]) {
            Byte[] array = (Byte[])obj;
            return array[0].longValue();
        }
        if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            return array[0];
        }
        if (obj instanceof String[]) {
            String[] array = (String[])obj;
            try {
                return new Long(array[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TypeCastException(obj.getClass());
            }
        }
        if (obj instanceof Boolean[]) {
            Boolean[] array = (Boolean[])obj;
            return array[0] != false ? 1 : 0;
        }
        if (obj instanceof boolean[]) {
            boolean[] array = (boolean[])obj;
            return array[0] ? 1 : 0;
        }
        throw new TypeCastException(obj.getClass());
    }

    public static long[] toLongArray(Object obj) throws TypeCastException {
        if (!ValueUtils.isArray(obj)) {
            long scalar = ValueUtils.toLongScalar(obj);
            return new long[]{scalar};
        }
        int len = ValueUtils.getArrayLength(obj);
        long[] result = new long[len];
        if (obj instanceof Calendar[]) {
            Calendar[] array = (Calendar[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].getTimeInMillis();
                ++i;
            }
            return result;
        }
        if (obj instanceof Integer[]) {
            Integer[] array = (Integer[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].longValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof int[]) {
            int[] array = (int[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Long[]) {
            Long[] array = (Long[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof long[]) {
            return (long[])obj;
        }
        if (obj instanceof Float[]) {
            Float[] array = (Float[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].longValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof float[]) {
            float[] array = (float[])obj;
            int i = 0;
            while (i < len) {
                result[i] = (long)array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Double[]) {
            Double[] array = (Double[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].longValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof double[]) {
            double[] array = (double[])obj;
            int i = 0;
            while (i < len) {
                result[i] = (long)array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Short[]) {
            Short[] array = (Short[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].longValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof short[]) {
            short[] array = (short[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Byte[]) {
            Byte[] array = (Byte[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].longValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof String[]) {
            String[] array = (String[])obj;
            int i = 0;
            while (i < len) {
                try {
                    result[i] = new Long(array[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TypeCastException(obj.getClass());
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof Boolean[]) {
            Boolean[] array = (Boolean[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i] != false ? 1 : 0;
                ++i;
            }
            return result;
        }
        if (obj instanceof boolean[]) {
            boolean[] array = (boolean[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i] ? 1 : 0;
                ++i;
            }
            return result;
        }
        throw new TypeCastException(obj.getClass());
    }

    public static int toIntegerScalar(Object obj) throws TypeCastException {
        if (!ValueUtils.isArray(obj)) {
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            if (obj instanceof String) {
                String str = (String)obj;
                try {
                    Integer d = new Integer(str);
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TypeCastException(obj.getClass());
                }
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1 : 0;
            }
            throw new TypeCastException(obj.getClass());
        }
        int len = ValueUtils.getArrayLength(obj);
        if (len != 1) {
            throw new TypeCastException("Expected length of array is 1");
        }
        if (obj instanceof double[]) {
            return ((int[])obj)[0];
        }
        if (obj instanceof int[]) {
            int[] array = (int[])obj;
            return array[0];
        }
        if (obj instanceof Integer[]) {
            Integer[] array = (Integer[])obj;
            return array[0];
        }
        if (obj instanceof Double[]) {
            Double[] array = (Double[])obj;
            return array[0].intValue();
        }
        if (obj instanceof Float[]) {
            Float[] array = (Float[])obj;
            return array[0].intValue();
        }
        if (obj instanceof float[]) {
            float[] array = (float[])obj;
            return (int)array[0];
        }
        if (obj instanceof Long[]) {
            Long[] array = (Long[])obj;
            return array[0].intValue();
        }
        if (obj instanceof long[]) {
            long[] array = (long[])obj;
            return (int)array[0];
        }
        if (obj instanceof Short[]) {
            Short[] array = (Short[])obj;
            return array[0].intValue();
        }
        if (obj instanceof short[]) {
            short[] array = (short[])obj;
            return array[0];
        }
        if (obj instanceof Byte[]) {
            Byte[] array = (Byte[])obj;
            return array[0].intValue();
        }
        if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            return array[0];
        }
        if (obj instanceof String[]) {
            String[] array = (String[])obj;
            try {
                return new Integer(array[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TypeCastException(obj.getClass());
            }
        }
        if (obj instanceof Boolean[]) {
            Boolean[] array = (Boolean[])obj;
            return array[0] != false ? 1 : 0;
        }
        if (obj instanceof boolean[]) {
            boolean[] array = (boolean[])obj;
            return array[0] ? 1 : 0;
        }
        throw new TypeCastException(obj.getClass());
    }

    public static int[] toIntegerArray(Object obj) throws TypeCastException {
        if (!ValueUtils.isArray(obj)) {
            int scalar = ValueUtils.toIntegerScalar(obj);
            return new int[]{scalar};
        }
        int len = ValueUtils.getArrayLength(obj);
        int[] result = new int[len];
        if (obj instanceof Integer[]) {
            Integer[] array = (Integer[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof long[]) {
            long[] array = (long[])obj;
            int i = 0;
            while (i < len) {
                result[i] = (int)array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Integer[]) {
            Integer[] array = (Integer[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof int[]) {
            return (int[])obj;
        }
        if (obj instanceof Float[]) {
            Float[] array = (Float[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].intValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof float[]) {
            float[] array = (float[])obj;
            int i = 0;
            while (i < len) {
                result[i] = (int)array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Double[]) {
            Double[] array = (Double[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].intValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof double[]) {
            double[] array = (double[])obj;
            int i = 0;
            while (i < len) {
                result[i] = (int)array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Short[]) {
            Short[] array = (Short[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].intValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof short[]) {
            short[] array = (short[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof Byte[]) {
            Byte[] array = (Byte[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i].intValue();
                ++i;
            }
            return result;
        }
        if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof String[]) {
            String[] array = (String[])obj;
            int i = 0;
            while (i < len) {
                try {
                    result[i] = new Integer(array[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TypeCastException(obj.getClass());
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof Boolean[]) {
            Boolean[] array = (Boolean[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i] != false ? 1 : 0;
                ++i;
            }
            return result;
        }
        if (obj instanceof boolean[]) {
            boolean[] array = (boolean[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i] ? 1 : 0;
                ++i;
            }
            return result;
        }
        throw new TypeCastException(obj.getClass());
    }

    public static boolean[] toBooleanArray(Object obj) throws TypeCastException {
        if (!ValueUtils.isArray(obj)) {
            boolean scalar = ValueUtils.toBooleanScalar(obj);
            return new boolean[]{scalar};
        }
        int len = ValueUtils.getArrayLength(obj);
        boolean[] result = new boolean[len];
        if (obj instanceof Integer[]) {
            Integer[] array = (Integer[])obj;
            int i = 0;
            while (i < len) {
                int value = array[i];
                if (value == 0) {
                    result[i] = false;
                } else if (value == 1) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof int[]) {
            int[] array = (int[])obj;
            int i = 0;
            while (i < len) {
                int value = array[i];
                if (value == 0) {
                    result[i] = false;
                } else if (value == 1) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof Boolean[]) {
            Boolean[] array = (Boolean[])obj;
            int i = 0;
            while (i < len) {
                result[i] = array[i];
                ++i;
            }
            return result;
        }
        if (obj instanceof boolean[]) {
            return (boolean[])obj;
        }
        if (obj instanceof Float[]) {
            Float[] array = (Float[])obj;
            int i = 0;
            while (i < len) {
                float value = array[i].floatValue();
                if (value == 0.0f) {
                    result[i] = false;
                } else if (value == 1.0f) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof float[]) {
            float[] array = (float[])obj;
            int i = 0;
            while (i < len) {
                float value = array[i];
                if (value == 0.0f) {
                    result[i] = false;
                } else if (value == 1.0f) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof Long[]) {
            Long[] array = (Long[])obj;
            int i = 0;
            while (i < len) {
                long value = array[i];
                if (value == 0L) {
                    result[i] = false;
                } else if (value == 1L) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof long[]) {
            long[] array = (long[])obj;
            int i = 0;
            while (i < len) {
                long value = array[i];
                if (value == 0L) {
                    result[i] = false;
                } else if (value == 1L) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof Short[]) {
            Short[] array = (Short[])obj;
            int i = 0;
            while (i < len) {
                short value = array[i];
                if (value == 0) {
                    result[i] = false;
                } else if (value == 1) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof short[]) {
            short[] array = (short[])obj;
            int i = 0;
            while (i < len) {
                short value = array[i];
                if (value == 0) {
                    result[i] = false;
                } else if (value == 1) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof Byte[]) {
            Byte[] array = (Byte[])obj;
            int i = 0;
            while (i < len) {
                byte value = array[i];
                if (value == 0) {
                    result[i] = false;
                } else if (value == 1) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            int i = 0;
            while (i < len) {
                byte value = array[i];
                if (value == 0) {
                    result[i] = false;
                } else if (value == 1) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof String[]) {
            String[] array = (String[])obj;
            int i = 0;
            while (i < len) {
                try {
                    result[i] = new Boolean(array[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TypeCastException(obj.getClass());
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof Double[]) {
            Double[] array = (Double[])obj;
            int i = 0;
            while (i < len) {
                double value = array[i];
                if (value == 0.0) {
                    result[i] = false;
                } else if (value == 1.0) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        if (obj instanceof double[]) {
            double[] array = (double[])obj;
            int i = 0;
            while (i < len) {
                double value = array[i];
                if (value == 0.0) {
                    result[i] = false;
                } else if (value == 1.0) {
                    result[i] = true;
                } else {
                    throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
                }
                ++i;
            }
            return result;
        }
        throw new TypeCastException(obj.getClass());
    }

    public static boolean toBooleanScalar(Object obj) throws TypeCastException {
        if (!ValueUtils.isArray(obj)) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof Byte) {
                byte value = (Byte)obj;
                if (value == 0) {
                    return false;
                }
                if (value == 1) {
                    return true;
                }
                throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
            }
            if (obj instanceof Short) {
                short value = (Short)obj;
                if (value == 0) {
                    return false;
                }
                if (value == 1) {
                    return true;
                }
                throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
            }
            if (obj instanceof Integer) {
                int value = (Integer)obj;
                if (value == 0) {
                    return false;
                }
                if (value == 1) {
                    return true;
                }
                throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
            }
            if (obj instanceof Long) {
                long value = (Long)obj;
                if (value == 0L) {
                    return false;
                }
                if (value == 1L) {
                    return true;
                }
                throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
            }
            if (obj instanceof Float) {
                float value = ((Float)obj).floatValue();
                if (value == 0.0f) {
                    return false;
                }
                if (value == 1.0f) {
                    return true;
                }
                throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
            }
            if (obj instanceof Double) {
                double value = (Double)obj;
                if (value == 0.0) {
                    return false;
                }
                if (value == 1.0) {
                    return true;
                }
                throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
            }
            if (obj instanceof String) {
                String value = (String)obj;
                if (value.equals("true") || value.equals("1")) {
                    return true;
                }
                if (value.equals("false") || value.equals("0")) {
                    return false;
                }
                throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
            }
            throw new TypeCastException(obj.getClass());
        }
        int len = ValueUtils.getArrayLength(obj);
        if (len != 1) {
            throw new TypeCastException("Expected length of array is 1");
        }
        if (obj instanceof boolean[]) {
            return ((boolean[])obj)[0];
        }
        if (obj instanceof Boolean[]) {
            Boolean[] array = (Boolean[])obj;
            return array[0];
        }
        if (obj instanceof int[]) {
            int value = ((int[])obj)[0];
            if (value == 0) {
                return false;
            }
            if (value == 1) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof Integer[]) {
            int value = ((Integer[])obj)[0];
            if (value == 0) {
                return false;
            }
            if (value == 1) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof Float[]) {
            float value = ((Float[])obj)[0].floatValue();
            if (value == 0.0f) {
                return false;
            }
            if (value == 1.0f) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof float[]) {
            float value = ((float[])obj)[0];
            if (value == 0.0f) {
                return false;
            }
            if (value == 1.0f) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof Long[]) {
            long value = ((Long[])obj)[0];
            if (value == 0L) {
                return false;
            }
            if (value == 1L) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof long[]) {
            long value = ((long[])obj)[0];
            if (value == 0L) {
                return false;
            }
            if (value == 1L) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof Short[]) {
            Short value = ((Short[])obj)[0];
            if (value == 0) {
                return false;
            }
            if (value == 1) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof short[]) {
            short value = ((short[])obj)[0];
            if (value == 0) {
                return false;
            }
            if (value == 1) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof Byte[]) {
            Byte value = ((Byte[])obj)[0];
            if (value == 0) {
                return false;
            }
            if (value == 1) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof byte[]) {
            byte value = ((byte[])obj)[0];
            if (value == 0) {
                return false;
            }
            if (value == 1) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof String[]) {
            String[] array = (String[])obj;
            String value = array[0];
            if (value.equals("true") || value.equals("1")) {
                return true;
            }
            if (value.equals("false") || value.equals("0")) {
                return false;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof Double[]) {
            double value = ((Double[])obj)[0];
            if (value == 0.0) {
                return false;
            }
            if (value == 1.0) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        if (obj instanceof double[]) {
            double value = ((double[])obj)[0];
            if (value == 0.0) {
                return false;
            }
            if (value == 1.0) {
                return true;
            }
            throw new TypeCastException("Cannot convert " + value + " to boolean value - 0 or 1 is expected");
        }
        throw new TypeCastException(obj.getClass());
    }

    public static <T> T adaptToClass(Object obj, Class<T> clazz) throws TypeCastException {
        if (clazz.equals(double[].class)) {
            return (T)ValueUtils.toDoubleArray(obj);
        }
        if (clazz.equals(Double.class)) {
            return (T)new Double(ValueUtils.toDoubleScalar(obj));
        }
        if (clazz.equals(float[].class)) {
            return (T)ValueUtils.toFloatArray(obj);
        }
        if (clazz.equals(Float.class)) {
            return (T)new Float(ValueUtils.toFloatScalar(obj));
        }
        if (clazz.equals(long[].class)) {
            return (T)ValueUtils.toLongArray(obj);
        }
        if (clazz.equals(Long.class)) {
            return (T)new Long(ValueUtils.toLongScalar(obj));
        }
        if (clazz.equals(int[].class)) {
            return (T)ValueUtils.toIntegerArray(obj);
        }
        if (clazz.equals(Integer.class)) {
            return (T)new Integer(ValueUtils.toIntegerScalar(obj));
        }
        if (clazz.equals(boolean[].class)) {
            return (T)ValueUtils.toBooleanArray(obj);
        }
        if (clazz.equals(Boolean.class)) {
            return (T)new Long(ValueUtils.toLongScalar(obj));
        }
        throw new TypeCastException("Unsupported conversion type from " + obj.getClass() + " to " + clazz);
    }

    public static String toString(Object obj) {
        if (obj instanceof Object[]) {
            return Arrays.toString((Object[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        return obj.toString();
    }
}

