/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public final class Segment
implements Comparable<Segment>,
Serializable,
Cloneable {
    public static final Segment ALL = new Segment(-1.7976931348623157E308, Double.MAX_VALUE);
    public static final Segment[] NO_RANGES = new Segment[0];
    private static final long serialVersionUID = 2979572023736175492L;
    private double start;
    private double end;
    private static final Comparator<Segment> COMPARATOR = new Comparator<Segment>(){

        @Override
        public int compare(Segment o1, Segment o2) {
            if (o1.start < o2.start) {
                return -1;
            }
            if (o1.start > o2.start) {
                return 1;
            }
            if (o1.end < o2.end) {
                return -1;
            }
            if (o1.end > o2.end) {
                return 1;
            }
            return 0;
        }
    };

    public static Segment at(double value) {
        return new Segment(value, value);
    }

    public static Segment of(double d1, double d2) {
        if (d1 < d2) {
            return new Segment(d1, d2);
        }
        return new Segment(d2, d1);
    }

    public Segment(double start, double end) {
        if (start > end) {
            throw new IllegalArgumentException("Start is after end");
        }
        this.start = start;
        this.end = end;
    }

    public Segment(double data) {
        this.start = data;
        this.end = data;
    }

    public Segment(double[] data) {
        assert (data.length == 2);
        this.start = data[0];
        this.end = data[1];
        if (this.start > this.end) {
            throw new IllegalArgumentException("Start is after end");
        }
    }

    public double getEnd() {
        return this.end;
    }

    public double getStart() {
        return this.start;
    }

    public double getLength() {
        return this.end - this.start;
    }

    public Segment createWithNewStart(double newStartData) {
        return new Segment(newStartData, this.end);
    }

    public Segment createWithNewEnd(double newEndData) {
        return new Segment(this.start, newEndData);
    }

    public Segment[] toArray() {
        Segment[] array = new Segment[]{this};
        return array;
    }

    public boolean contains(double value) {
        return value >= this.start && value <= this.end;
    }

    public boolean contains(Segment s) {
        return this.start <= s.start && this.end >= s.end;
    }

    public boolean parallelWith(Segment s) {
        if (s.start > this.end) {
            return false;
        }
        return !(s.end < this.start);
    }

    public boolean intersects(Segment s) {
        if (s.start >= this.end) {
            return false;
        }
        return !(s.end <= this.start);
    }

    public Segment extendWith(Segment s) {
        double newEnd;
        if (this.contains(s)) {
            return this;
        }
        if (s.contains(this)) {
            return s;
        }
        double newStart = this.start;
        if (s.start < newStart) {
            newStart = s.start;
        }
        if (s.end > (newEnd = this.end)) {
            newEnd = s.end;
        }
        return new Segment(newStart, newEnd);
    }

    public Segment extendWith(double value) {
        if (this.contains(value)) {
            return this;
        }
        return new Segment(value < this.start ? value : this.start, value > this.end ? value : this.end);
    }

    public Segment[] intersection(Segment s) {
        Segment[] list = new Segment[]{this, s};
        return Segment.intersection(list);
    }

    public Segment[] union(Segment range) {
        Segment[] list = new Segment[]{this, range};
        return Segment.union(list);
    }

    public static Segment[] intersection(Segment[] segments1, Segment[] segments2) {
        return Segment.intersection(Segment.concat(segments1, segments2));
    }

    public static Segment[] union(Segment[] segments1, Segment[] segments2) {
        return Segment.union(Segment.concat(segments1, segments2));
    }

    public static Segment[] difference(Segment[] group, Segment cutWith) {
        if (group.length == 0) {
            return group;
        }
        ArrayList<Segment> result = new ArrayList<Segment>(group.length + 2);
        Segment[] segmentArray = group;
        int n = group.length;
        int n2 = 0;
        while (n2 < n) {
            Segment range = segmentArray[n2];
            if (!(cutWith.start <= range.start) || !(cutWith.end >= range.end)) {
                if (cutWith.start >= range.end || cutWith.end <= range.start) {
                    result.add(range);
                } else if (cutWith.start > range.start && cutWith.end < range.end) {
                    result.add(new Segment(range.start, cutWith.start));
                    result.add(new Segment(cutWith.end, range.end));
                } else if (cutWith.start <= range.start) {
                    result.add(new Segment(cutWith.end, range.end));
                } else if (cutWith.end >= range.end) {
                    result.add(new Segment(range.start, cutWith.start));
                }
            }
            ++n2;
        }
        return result.toArray(NO_RANGES);
    }

    public static Segment[] difference(Segment[] segments1, Segment[] segments2) {
        Segment[] temp = segments1;
        Segment[] segmentArray = segments2;
        int n = segments2.length;
        int n2 = 0;
        while (n2 < n) {
            Segment s = segmentArray[n2];
            temp = Segment.difference(temp, s);
            ++n2;
        }
        return temp;
    }

    public static Segment[] concat(Segment[] array1, Segment[] array2) {
        Segment[] result = new Segment[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    Segment intersectWith(Segment s) {
        double newEnd;
        if (!this.intersects(s)) {
            return null;
        }
        double newStart = this.start;
        if (s.start > newStart) {
            newStart = s.start;
        }
        if (s.end < (newEnd = this.end)) {
            newEnd = s.end;
        }
        return new Segment(newStart, newEnd);
    }

    Segment differenceWith(Segment s) {
        if (!this.intersects(s)) {
            return this;
        }
        double newStart = this.start;
        double newEnd = this.end;
        if (s.start < newEnd) {
            newEnd = s.start;
        }
        if (s.end > newStart) {
            newStart = s.end;
        }
        if (newEnd < newStart) {
            return null;
        }
        return new Segment(newStart, newEnd);
    }

    public static Segment[] intersection(Segment[] group) {
        group = Segment.sort(group);
        int count = 0;
        Segment[] temp = new Segment[group.length];
        Segment base = group[0];
        int i = 1;
        while (i < group.length) {
            Segment r = group[i];
            Segment is = base.intersectWith(r);
            if (is != null) {
                temp[count++] = is;
            }
            base = r.parallelWith(base) ? base.extendWith(r) : r;
            ++i;
        }
        return Segment.resizeArray(temp, count);
    }

    public static Segment[] union(Segment[] group) {
        if (group.length <= 1) {
            return group;
        }
        group = Segment.sort(group);
        int count = 0;
        Segment[] temp = new Segment[group.length];
        Segment base = group[0];
        int i = 1;
        while (i < group.length) {
            Segment r = group[i];
            if (r.parallelWith(base)) {
                base = base.extendWith(r);
            } else {
                temp[count++] = base;
                base = r;
            }
            ++i;
        }
        temp[count++] = base;
        return Segment.resizeArray(temp, count);
    }

    public static Segment[] resizeArray(Segment[] array, int newLength) {
        int oldLength = array.length;
        if (oldLength == newLength) {
            return array;
        }
        Segment[] newArray = new Segment[newLength];
        if (newLength < oldLength) {
            System.arraycopy(array, 0, newArray, 0, newLength);
        } else {
            System.arraycopy(array, 0, newArray, 0, oldLength);
        }
        return newArray;
    }

    public static Segment[] sort(Segment[] group) {
        Segment[] result = (Segment[])group.clone();
        Arrays.sort(result, COMPARATOR);
        return result;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.start);
        int hash = (int)(bits ^ bits >>> 32);
        bits = Double.doubleToLongBits(this.end);
        return hash ^= (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)obj;
        return other.end == this.end && other.start == this.start;
    }

    @Override
    public int compareTo(Segment other) {
        double diffrence = this.start - other.start;
        if (diffrence < 0.0) {
            return -1;
        }
        if (diffrence > 0.0) {
            return 1;
        }
        diffrence = this.end - other.end;
        if (diffrence < 0.0) {
            return -1;
        }
        if (diffrence > 0.0) {
            return 1;
        }
        return 0;
    }

    public Segment clone() {
        return new Segment(this.start, this.end);
    }

    public String toString() {
        return "[" + this.start + ".." + this.end + "]";
    }

    public static String toString(Segment[] array) {
        return Arrays.toString(array);
    }
}

