/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.simantics.utils.datastructures.ImmutableCollection;

public class ImmutableSList<T>
extends ImmutableCollection<T> {
    public final T head;
    public final ImmutableSList<T> tail;

    public ImmutableSList(T head, ImmutableSList<T> tail) {
        this.head = head;
        this.tail = tail;
    }

    public ImmutableSList(T head) {
        this(head, null);
    }

    @Override
    public boolean contains(Object o) {
        ImmutableSList<T> cur = this;
        do {
            if (!cur.head.equals(o)) continue;
            return true;
        } while ((cur = cur.tail) != null);
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter(this);
    }

    @Override
    public int size() {
        ImmutableSList<T> cur = this;
        int count = 0;
        do {
            ++count;
        } while ((cur = cur.tail) != null);
        return count;
    }

    private static class Iter<T>
    implements Iterator<T> {
        public ImmutableSList<T> cur;

        public Iter(ImmutableSList<T> cur) {
            this.cur = cur;
        }

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        @Override
        public T next() {
            if (this.cur == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.cur.head;
            this.cur = this.cur.tail;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

