/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.bytes;

public class BEInt {
    public static byte[] toBytes(int value) {
        byte[] array = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        return array;
    }

    public static void write(int value, byte[] array, int offset) {
        if (offset + 4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        array[0 + offset] = (byte)(value & 0xFF);
        array[1 + offset] = (byte)(value >> 8);
        array[2 + offset] = (byte)(value >> 16);
        array[3 + offset] = (byte)(value >> 24);
    }

    public static void write(int value, byte[] array) {
        if (array.length < 4) {
            throw new IndexOutOfBoundsException();
        }
        array[0] = (byte)(value & 0xFF);
        array[1] = (byte)(value >> 8);
        array[2] = (byte)(value >> 16);
        array[3] = (byte)(value >> 24);
    }

    public static int toInt(byte[] array, int offset) {
        if (offset + 4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        int value = array[0 + offset] & 0xFF | (array[1 + offset] & 0xFF) << 8 | (array[2 + offset] & 0xFF) << 16 | (array[3 + offset] & 0xFF) << 24;
        return value;
    }

    public static int toInt(byte[] array) {
        if (4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        int value = array[0] & 0xFF | (array[1] & 0xFF) << 8 | (array[2] & 0xFF) << 16 | (array[3] & 0xFF) << 24;
        return value;
    }

    public static void main(String[] args) {
        System.out.println("min=-2147483648 max=2147483647");
        int value = -1290000000;
        byte[] array = BEInt.toBytes(value);
        System.out.print(value);
        System.out.print(" = ");
        BEInt.printByteArray(array);
        System.out.println();
        BEInt.write(value, array, 0);
        System.out.print(value);
        System.out.print(" = ");
        BEInt.printByteArray(array);
        System.out.println();
        BEInt.write(value, array);
        System.out.print(value);
        System.out.print(" = ");
        BEInt.printByteArray(array);
        System.out.println();
        value = BEInt.toInt(array, 0);
        BEInt.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
        value = BEInt.toInt(array);
        BEInt.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
    }

    public static void printByteArray(byte[] array) {
        int i = 0;
        while (i < array.length) {
            System.out.print(array[i] & 0xFF);
            if (i < array.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
    }
}

