/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils;

import java.io.File;
import java.util.Properties;

public class LibraryPathUtils {
    public static void addCLASSPATHtoEclipseVariables() {
        String classPath;
        int n;
        int n2;
        String[] stringArray;
        String CLASSPATH = System.getenv("CLASSPATH");
        if (CLASSPATH != null) {
            stringArray = CLASSPATH.split(";");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                classPath = stringArray[n];
                if (!classPath.toLowerCase().endsWith(".jar")) {
                    LibraryPathUtils.addLibraryPath(classPath);
                }
                LibraryPathUtils.addClassPath(classPath);
                ++n;
            }
        }
        if ((CLASSPATH = System.getenv("PATH")) != null) {
            stringArray = CLASSPATH.split(";");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                classPath = stringArray[n];
                LibraryPathUtils.addLibraryPath(classPath);
                ++n;
            }
        }
        if ((CLASSPATH = System.getenv("LD_LIBRARY_PATH")) != null) {
            stringArray = CLASSPATH.split(";");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                classPath = stringArray[n];
                LibraryPathUtils.addLibraryPath(classPath);
                ++n;
            }
        }
    }

    public static void addLibraryPath(String newLibrary) {
        if (newLibrary == null || "".equals(newLibrary)) {
            return;
        }
        String java_library_path = System.getProperty("java.library.path");
        if (java_library_path != null) {
            String[] stringArray = java_library_path.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String library = stringArray[n2];
                if (library.equals(newLibrary)) {
                    return;
                }
                ++n2;
            }
        }
        if (java_library_path == null || "".equals(java_library_path)) {
            java_library_path = newLibrary;
        } else {
            if (!java_library_path.endsWith(";")) {
                java_library_path = String.valueOf(java_library_path) + ";";
            }
            java_library_path = String.valueOf(java_library_path) + newLibrary + ";";
        }
        System.setProperty("java.library.path", java_library_path);
    }

    public static void addClassPath(String newLibrary) {
        if (newLibrary == null || "".equals(newLibrary)) {
            return;
        }
        String java_library_path = System.getProperty("java.class.path");
        if (java_library_path != null) {
            String[] stringArray = java_library_path.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String library = stringArray[n2];
                if (library.equals(newLibrary)) {
                    return;
                }
                ++n2;
            }
        }
        if (java_library_path == null || "".equals(java_library_path)) {
            java_library_path = newLibrary;
        } else {
            if (!java_library_path.endsWith(";")) {
                java_library_path = String.valueOf(java_library_path) + ";";
            }
            java_library_path = String.valueOf(java_library_path) + newLibrary + ";";
        }
        System.setProperty("java.class.path", java_library_path);
    }

    public static void printEnvVariables() {
        Object value;
        Properties props = System.getProperties();
        for (Object object : props.keySet()) {
            value = props.get(object);
            System.out.println(object + "=" + value);
        }
        System.out.println("\n\nEnv:");
        for (Object object : System.getenv().keySet()) {
            value = System.getenv().get(object);
            System.out.println(object + "=" + value);
        }
    }

    public static String findLibrary(String library) {
        String classPath;
        String CLASSPATH = System.getenv("CLASSPATH");
        if (CLASSPATH == null) {
            return null;
        }
        String[] stringArray = CLASSPATH.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            classPath = stringArray[n2];
            if (classPath.endsWith(library)) {
                return classPath;
            }
            ++n2;
        }
        stringArray = CLASSPATH.split(";");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            classPath = stringArray[n2];
            if (classPath.toLowerCase().endsWith(library.toLowerCase())) {
                return classPath;
            }
            ++n2;
        }
        return null;
    }

    public static void createSystemPropertiesFromClassPathLibraries() {
        String CLASSPATH = System.getenv("CLASSPATH");
        if (CLASSPATH == null) {
            return;
        }
        String[] stringArray = CLASSPATH.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            File lib;
            String classPath = stringArray[n2];
            if (classPath.toLowerCase().endsWith(".jar") && (lib = new File(classPath)).exists()) {
                String key = lib.getName();
                String value = lib.getAbsolutePath();
                System.setProperty(key, value);
            }
            ++n2;
        }
    }
}

