/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.generator.compression;

import java.util.Arrays;
import org.simantics.scl.compiler.parser.generator.compression.CompressedTable;

public class CompressTable {
    public static CompressedTable compress(int[][] table_) {
        int el;
        int j;
        Object[] table = new Row[table_.length];
        int i = 0;
        while (i < table.length) {
            Row row = new Row();
            row.id = i;
            row.data = table_[i];
            int density = 0;
            int minPos = -1;
            int maxPos = -1;
            j = 0;
            while (j < row.data.length) {
                el = row.data[j];
                if (el != 0) {
                    ++density;
                    if (minPos == -1) {
                        minPos = j;
                    }
                    maxPos = j;
                }
                ++j;
            }
            row.density = density;
            row.minPos = minPos;
            row.maxPos = maxPos;
            table[i] = row;
            ++i;
        }
        Arrays.sort(table);
        int width = table_.length == 0 ? 0 : table_[0].length;
        int capacity = 2 * table_.length * width;
        int[] rowIds = new int[capacity];
        Arrays.fill(rowIds, -1);
        int[] values = new int[capacity];
        Object[] objectArray = table;
        el = table.length;
        j = 0;
        while (j < el) {
            Object row = objectArray[j];
            if (((Row)row).density == 0) {
                ((Row)row).displacement = capacity / 2;
            } else {
                int dId = 0;
                while (dId < capacity) {
                    block16: {
                        int id;
                        int d = capacity / 2 + ((dId & 1) == 0 ? dId / 2 : -1 - dId / 2);
                        int p = ((Row)row).minPos;
                        while (p <= ((Row)row).maxPos) {
                            int newValue = ((Row)row).data[p];
                            if (newValue == 0 || rowIds[id = d + p] < 0) {
                                ++p;
                                continue;
                            }
                            break block16;
                        }
                        ((Row)row).displacement = d;
                        p = ((Row)row).minPos;
                        while (p <= ((Row)row).maxPos) {
                            int val = ((Row)row).data[p];
                            if (val != 0) {
                                id = d + p;
                                rowIds[id] = ((Row)row).id;
                                values[id] = val;
                            }
                            ++p;
                        }
                        break;
                    }
                    ++dId;
                }
            }
            ++j;
        }
        int minDis = capacity;
        int maxDis = 0;
        Object[] objectArray2 = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            Object row = objectArray2[n2];
            int d = ((Row)row).displacement;
            if (d < minDis) {
                minDis = d;
            }
            if (d > maxDis) {
                maxDis = d;
            }
            ++n2;
        }
        int[] displacement = new int[table.length];
        int i2 = 0;
        while (i2 < table.length) {
            displacement[((Row)table[i2]).id] = ((Row)table[i2]).displacement - minDis;
            ++i2;
        }
        rowIds = Arrays.copyOfRange(rowIds, minDis, maxDis + width);
        values = Arrays.copyOfRange(values, minDis, maxDis + width);
        return new CompressedTable(rowIds, values, displacement);
    }

    private static class Row
    implements Comparable<Row> {
        int id;
        int density;
        int minPos;
        int maxPos;
        int[] data;
        int displacement;

        private Row() {
        }

        @Override
        public int compareTo(Row o) {
            return o.density < this.density ? 1 : (o.density > this.density ? -1 : 0);
        }
    }
}

