/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.documentation;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.scl.compiler.elaboration.modules.Documentation;
import org.simantics.scl.compiler.internal.parsing.documentation.DocumentationElement;
import org.simantics.scl.compiler.internal.parsing.documentation.DocumentationLexer;
import org.simantics.scl.compiler.internal.parsing.documentation.DocumentationParsingException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public abstract class HtmlUnparsingContext {
    StringBuilder stringBuilder;
    String listLevel = "";
    int tableOfContentsLevel = 0;
    StringBuilder tableOfContents;
    int headerLinkId = 0;
    private static final Pattern PARAGRAPH_PATTERN = Pattern.compile("'[^ ']+'|@[^@]+@");

    public HtmlUnparsingContext(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
        this.tableOfContents = null;
    }

    public HtmlUnparsingContext() {
        this(new StringBuilder());
        this.tableOfContents = new StringBuilder();
    }

    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public StringBuilder getTableOfContents() {
        return this.tableOfContents;
    }

    public void finishTableOfContents() {
        while (this.tableOfContentsLevel > 0) {
            this.tableOfContents.append("</ul>\n");
            --this.tableOfContentsLevel;
        }
    }

    public void header(int level, String text) {
        this.clear();
        ++this.headerLinkId;
        this.stringBuilder.append("<h").append(level).append(" id=\"sec").append(this.headerLinkId).append("\">").append(text).append("</h").append(level).append(">\n");
        while (this.tableOfContentsLevel > level) {
            this.tableOfContents.append("</ul>\n");
            --this.tableOfContentsLevel;
        }
        while (this.tableOfContentsLevel < level) {
            this.tableOfContents.append("<ul>\n");
            ++this.tableOfContentsLevel;
        }
        this.tableOfContents.append("<li><a href=\"#sec").append(this.headerLinkId).append("\">").append(text).append("</a></li>\n");
    }

    public void clear() {
        this.setListLevel("");
    }

    public void setListLevel(String newLevel) {
        char c;
        String oldLevel = this.listLevel;
        int commonLevel = 0;
        while (commonLevel < oldLevel.length() && commonLevel < newLevel.length() && newLevel.charAt(commonLevel) == oldLevel.charAt(commonLevel)) {
            ++commonLevel;
        }
        int i = oldLevel.length() - 1;
        while (i >= commonLevel) {
            c = oldLevel.charAt(i);
            if (c == '*') {
                this.stringBuilder.append("</ul>\n");
            } else if (c == '#') {
                this.stringBuilder.append("</ol>\n");
            }
            --i;
        }
        i = commonLevel;
        while (i < newLevel.length()) {
            c = newLevel.charAt(i);
            if (c == '*') {
                this.stringBuilder.append("<ul>\n");
            } else if (c == '#') {
                this.stringBuilder.append("<ol>\n");
            }
            ++i;
        }
        this.listLevel = newLevel;
    }

    public void appendDocumentation(String doc) {
        DocumentationLexer lexer = new DocumentationLexer(new StringReader(doc));
        this.clear();
        while (true) {
            DocumentationElement element = null;
            try {
                element = lexer.nextToken();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DocumentationParsingException e) {
                e.printStackTrace();
            }
            if (element == null) break;
            element.toHtml(this);
        }
        this.clear();
    }

    public static String escape(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public abstract void documentEntity(String var1);

    public void appendType(TypeUnparsingContext tuc, Type type, int precedence) {
        StringBuilder b = new StringBuilder();
        type.toString(tuc, b, precedence);
        this.stringBuilder.append(HtmlUnparsingContext.escape(b.toString()));
    }

    public void appendType(TypeUnparsingContext tuc, Type type) {
        this.appendType(tuc, type, 3);
    }

    public void appendRef(String ref) {
        this.stringBuilder.append("<a name=\"").append(ref).append("\" class=\"ref\">").append(HtmlUnparsingContext.escape(ref)).append("</a>");
    }

    public Documentation toDocumentation() {
        this.finishTableOfContents();
        return new Documentation(this.stringBuilder.toString(), this.tableOfContents.toString());
    }

    public void appendParagraph(String text) {
        this.clear();
        this.stringBuilder.append("<p>");
        Matcher m = PARAGRAPH_PATTERN.matcher(text);
        int lastAppend = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            this.stringBuilder.append(text, lastAppend, start);
            char c = text.charAt(start);
            if (c == '\'') {
                String ref = text.substring(start + 1, end - 1);
                this.stringBuilder.append("<code><a href=\"#").append(ref).append("\">").append(ref).append("</a></code>");
            } else if (c == '@') {
                this.stringBuilder.append("<code>").append(text, start + 1, end - 1).append("</code>");
            }
            lastAppend = end;
        }
        this.stringBuilder.append(text, lastAppend, text.length());
        this.stringBuilder.append("</p>\n");
    }
}

