/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.utils;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import gnu.trove.set.hash.THashSet;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.SCLConstant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.continuations.ContRef;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSAValidationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSAValidationContext.class);
    public THashSet<BoundVar> validBoundVariables = new THashSet();
    public THashSet<Cont> validContinuations = new THashSet();
    public THashSet<TVar> validTypeVariables = new THashSet();
    public TObjectIntHashMap<Val> refCount = new TObjectIntHashMap();
    public Object errorMarker = null;
    boolean invalidReferenceCounts;

    public void assertEquals(Object loc, Type a, Type b) {
        if (!Types.equals(a, b)) {
            TypeUnparsingContext tuc = new TypeUnparsingContext();
            String message = String.valueOf(a.toString(tuc)) + " != " + b.toString(tuc);
            LOGGER.error(message);
            this.setErrorMarker(loc);
            throw new InternalCompilerError(message);
        }
    }

    public void assertSubsumes(Object loc, Type a, Type b) {
        if (!Types.subsumes(a, b)) {
            TypeUnparsingContext tuc = new TypeUnparsingContext();
            this.setErrorMarker(loc);
            throw new InternalCompilerError(String.valueOf(a.toString(tuc)) + " <! " + b.toString(tuc));
        }
    }

    public void assertEqualsEffect(Object loc, Type a, Type b) {
        if (!Types.equalsEffect(a, b)) {
            TypeUnparsingContext tuc = new TypeUnparsingContext();
            String message = String.valueOf(a.toString(tuc)) + " != " + b.toString(tuc);
            LOGGER.error(message);
            this.setErrorMarker(loc);
            throw new InternalCompilerError(message);
        }
    }

    public void assertEquals(int a, int b) {
        if (a != b) {
            throw new InternalCompilerError();
        }
    }

    public void reset() {
        this.validContinuations.clear();
        this.validTypeVariables.clear();
    }

    public void validate(Cont cont) {
        int i = 0;
        while (i < cont.getArity()) {
            this.validateType(cont.getParameterType(i));
            ++i;
        }
    }

    public void validate(Val val) {
        this.validateType(val.getType());
    }

    private static boolean hasOccurrence(Cont cont, ContRef occ) {
        ContRef ref = cont.getOccurrence();
        while (ref != null) {
            if (ref == occ) {
                return true;
            }
            ref = ref.getNext();
        }
        return false;
    }

    public void validate(ContRef ref) {
        if (!this.validContinuations.contains((Object)ref.getBinding())) {
            throw new InternalCompilerError();
        }
        if (!SSAValidationContext.hasOccurrence(ref.getBinding(), ref)) {
            throw new InternalCompilerError();
        }
        if (ref.getParent() == null) {
            throw new InternalCompilerError();
        }
    }

    public void checkReferences() {
        this.invalidReferenceCounts = false;
        this.refCount.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<Val>(){

            public boolean execute(Val val, int count) {
                int realCount;
                if (val instanceof Constant) {
                    if (!(val instanceof SCLConstant)) {
                        return true;
                    }
                    if (!((SCLConstant)val).getName().module.equals("Composition")) {
                        return true;
                    }
                }
                if ((realCount = val.occurrenceCount()) != count) {
                    LOGGER.warn(val + ": " + realCount + " != " + count);
                    SSAValidationContext.this.invalidReferenceCounts = true;
                }
                return true;
            }
        });
        if (this.invalidReferenceCounts) {
            throw new InternalCompilerError();
        }
    }

    public void validate(ValRef ref) {
        this.refCount.adjustOrPutValue((Object)ref.getBinding(), 1, 1);
        Val val = ref.getBinding();
        if (val == null) {
            throw new InternalCompilerError();
        }
        if (val instanceof Constant) {
            return;
        }
        if (!this.validBoundVariables.contains((Object)val)) {
            throw new InternalCompilerError();
        }
        if (ref.getParent() == null) {
            throw new InternalCompilerError();
        }
    }

    public void validateType(Type type) {
    }

    public void setErrorMarker(Object errorMarker) {
        this.errorMarker = errorMarker;
    }
}

