/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.interpreted.IConstant;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.internal.interpreted.IIf;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.runtime.tuple.Tuple0;

public class EIf
extends Expression {
    public Expression condition;
    public Expression then_;
    public Expression else_;

    public EIf(Expression condition, Expression then_, Expression else_) {
        this.condition = condition;
        this.then_ = then_;
        this.else_ = else_;
    }

    public EIf(long loc, Expression condition, Expression then_, Expression else_) {
        super(loc);
        this.condition = condition;
        this.then_ = then_;
        this.else_ = else_;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.then_.getType());
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        IVal conditionVal = this.condition.toVal(context, w);
        CodeWriter joinPoint = w.createBlock(this.getType());
        CodeWriter thenBlock = w.createBlock();
        if (this.else_ != null) {
            CodeWriter elseBlock = w.createBlock();
            w.if_(this.location, conditionVal, thenBlock.getContinuation(), elseBlock.getContinuation());
            IVal elseVal = this.else_.toVal(context, elseBlock);
            elseBlock.jump(this.location, joinPoint.getContinuation(), elseVal);
        } else {
            w.if_(this.location, conditionVal, thenBlock.getContinuation(), joinPoint.getContinuation());
        }
        IVal thenVal = this.then_.toVal(context, thenBlock);
        thenBlock.jump(this.location, joinPoint.getContinuation(), thenVal);
        w.continueAs(joinPoint);
        return w.getParameters()[0];
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.condition = this.condition.simplify(context);
        this.then_ = this.then_.simplify(context);
        if (this.else_ != null) {
            this.else_ = this.else_.simplify(context);
        }
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.condition = this.condition.resolve(context);
        this.then_ = this.then_.resolve(context);
        if (this.else_ != null) {
            this.else_ = this.else_.resolve(context);
        }
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        return new EIf(this.condition.replace(context), this.then_.replace(context), this.else_ == null ? null : this.else_.replace(context));
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.condition = this.condition.checkType(context, Types.BOOLEAN);
        this.then_ = this.then_.checkType(context, requiredType);
        if (this.else_ != null) {
            this.else_ = this.else_.checkType(context, requiredType);
        } else {
            context.getErrorLog().log(this.location, "Else branch is required because the return value of the if expression is used.");
        }
        return this;
    }

    @Override
    public Expression checkIgnoredType(TypingContext context) {
        this.condition = this.condition.checkType(context, Types.BOOLEAN);
        this.then_ = this.then_.checkIgnoredType(context);
        if (this.else_ != null) {
            this.else_ = this.else_.checkIgnoredType(context);
        }
        return this;
    }

    @Override
    public boolean isEffectful() {
        return this.condition.isEffectful() || this.then_.isEffectful() || this.else_ != null && this.else_.isEffectful();
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.condition.setLocationDeep(loc);
            this.then_.setLocationDeep(loc);
            if (this.else_ != null) {
                this.else_.setLocationDeep(loc);
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public IExpression toIExpression(ExpressionInterpretationContext target) {
        return new IIf(this.condition.toIExpression(target), this.then_.toIExpression(target), this.else_ != null ? this.else_.toIExpression(target) : new IConstant(Tuple0.INSTANCE));
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public int getSyntacticFunctionArity() {
        return Math.max(this.then_.getSyntacticFunctionArity(), this.else_.getSyntacticFunctionArity());
    }
}

