/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.contexts;

import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EIf;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.MultiFunction;

public class SimplificationContext
implements EnvironmentalContext {
    CompilationContext compilationContext;
    Environment environment;
    ErrorLog errorLog;
    THashMap<Name, SCLValue> constants = new THashMap();
    THashMap<Variable, Expression> inlinedVariables = new THashMap();
    TLongArrayList locatableStack = new TLongArrayList();
    long locatable;
    JavaTypeTranslator javaTypeTranslator;
    JavaReferenceValidator<?, ?, ?, ?> validator;

    public SimplificationContext(CompilationContext compilationContext, JavaReferenceValidator<?, ?, ?, ?> validator) {
        this.compilationContext = compilationContext;
        this.environment = compilationContext.environment;
        this.errorLog = compilationContext.errorLog;
        this.javaTypeTranslator = compilationContext.javaTypeTranslator;
        this.validator = validator;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ErrorLog getErrorLog() {
        return this.errorLog;
    }

    public void pushLocation(long loc) {
        this.locatableStack.add(this.locatable);
        this.locatable = loc;
    }

    public void popLocation() {
        this.locatable = this.locatableStack.removeAt(this.locatableStack.size() - 1);
    }

    @Override
    public SCLValue getValue(Name name) {
        if (this.constants.containsKey((Object)name)) {
            return (SCLValue)this.constants.get((Object)name);
        }
        SCLValue value = this.environment.getValue(name);
        if (value == null) {
            this.errorLog.log(this.locatable, "Couldn't find " + name + ".");
        }
        this.constants.put((Object)name, (Object)value);
        return value;
    }

    public Expression getConstant(Name name, Type ... typeParameters) {
        SCLValue value = this.getValue(name);
        if (value == null) {
            return new EError(this.locatable);
        }
        return new EConstant(value, typeParameters);
    }

    public Expression apply(Expression f, Expression ... ps) {
        Expression result = f;
        Type type = f.getType();
        Expression[] expressionArray = ps;
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            MultiFunction mfun;
            Expression p = expressionArray[n2];
            result = new EApply(this.locatable, result, p);
            try {
                mfun = Types.matchFunction(type, 1);
            }
            catch (MatchException e) {
                throw new InternalCompilerError(e);
            }
            type = mfun.returnType;
            result.setType(type);
            ++n2;
        }
        return result;
    }

    public Expression tuple(Expression ... cs) {
        if (cs.length == 1) {
            return cs[0];
        }
        Type[] typeParameters = new Type[cs.length];
        int i = 0;
        while (i < cs.length) {
            typeParameters[i] = cs[i].getType();
            ++i;
        }
        Expression result = new EConstant(this.locatable, Builtins.TUPLE_CONSTRUCTORS[cs.length], typeParameters);
        Expression[] expressionArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            Expression c = expressionArray[n2];
            result = new EApply(this.locatable, result, c);
            ++n2;
        }
        result.setType(Types.tuple(Types.getTypes(cs)));
        return result;
    }

    public Expression var(Variable var) {
        EVariable result = new EVariable(this.locatable, var);
        result.setType(var.getType());
        return result;
    }

    public Expression simpleLambda(Variable var, Expression val) {
        ESimpleLambda result = new ESimpleLambda(var, val);
        result.setType(Types.function(var.getType(), val.getType()));
        return result;
    }

    public Expression lambda(Expression pat, Expression val) {
        return new ELambda(this.locatable, pat, val);
    }

    public Expression lambda(Case ... cases) {
        return new ELambda(this.locatable, cases);
    }

    public Expression if_(Expression condition, Expression then_, Expression else_) {
        return new EIf(this.locatable, condition, then_, else_);
    }

    public Expression mapList(Expression f, Expression l) {
        try {
            MultiFunction mfun = Types.matchFunction(f.getType(), 1);
            return this.apply(this.getConstant(Names.Prelude_mapList, mfun.parameterTypes[0], mfun.returnType), f, l);
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }

    public Expression guardList(Expression cond) {
        return this.apply(this.getConstant(Names.Prelude_guardList, new Type[0]), cond);
    }

    public Expression concatMap(Expression f, Expression l) {
        try {
            MultiFunction mfun = Types.matchFunction(f.getType(), 1);
            return this.apply(this.getConstant(Names.Prelude_concatMap, mfun.parameterTypes[0], mfun.effect, Types.matchApply(Types.LIST, mfun.returnType)), f, l);
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }

    public Expression emptyList(Type type) {
        return this.getConstant(Names.Prelude_emptyList, type);
    }

    public Expression singletonList(Expression e) {
        return this.apply(this.getConstant(Names.Prelude_singletonList, e.getType()), e);
    }

    public Expression match(Expression scrutinee, Expression pattern, Expression value) {
        Case case_ = new Case(pattern, value);
        return new EMatch(scrutinee, case_);
    }

    public Expression match(Expression scrutinee, Case ... cases) {
        return new EMatch(scrutinee, cases);
    }

    public Expression literal(Constant constant) {
        return new ELiteral(constant);
    }

    public JavaReferenceValidator<Object, Object, Object, Object> getJavaReferenceValidator() {
        return this.validator;
    }

    public JavaTypeTranslator getJavaTypeTranslator() {
        return this.javaTypeTranslator;
    }

    public void addInlinedVariable(Variable variable, Expression value) {
        this.inlinedVariables.put((Object)variable, (Object)value);
    }

    public Expression getInlinedValue(Variable variable) {
        return (Expression)this.inlinedVariables.get((Object)variable);
    }

    public EVariable blank() {
        return new EVariable(new Variable("_"));
    }

    public Expression conditionalExecution(Expression condition, Expression continuation) {
        return new EIf(condition, continuation, new EConstant(Builtins.TUPLE_CONSTRUCTORS[0]));
    }

    public Expression iteratedExecution(Expression list, Variable variable, Expression continuation) {
        return new EApply(9223372034707292160L, Types.PROC, this.getConstant(Names.Prelude_iterList, variable.getType(), Types.PROC, Types.tupleConstructor(0)), new ESimpleLambda(Types.PROC, variable, continuation), list);
    }

    public Expression iteratedVectorExecution(EApply vector, Variable variable, Expression continuation) {
        return new EApply(9223372034707292160L, Types.PROC, this.getConstant(Names.Vector_iterVector, variable.getType(), Types.PROC, Types.tupleConstructor(0)), new ESimpleLambda(Types.PROC, variable, continuation), vector);
    }

    public Expression[] vars(Variable[] parameters) {
        Expression[] result = new Expression[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            result[i] = new EVariable(parameters[i]);
            ++i;
        }
        return result;
    }

    public CompilationContext getCompilationContext() {
        return this.compilationContext;
    }
}

