/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.completions;

public class PrefixUtil {
    public static String findPrefix(String sourceText, int end) {
        int position = end - 1;
        while (position >= 0 && PrefixUtil.isPrefixChar(sourceText.charAt(position))) {
            --position;
        }
        ++position;
        while (position < end && !PrefixUtil.isPrefixStart(sourceText.charAt(position))) {
            ++position;
        }
        return sourceText.substring(position, end);
    }

    private static boolean isPrefixStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    private static boolean isPrefixChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.';
    }

    public static String[] splitPrefix(String prefix) {
        int partCount = 1;
        int i = 0;
        while (i < prefix.length()) {
            if (prefix.charAt(i) == '.') {
                ++partCount;
            }
            ++i;
        }
        String[] result = new String[partCount];
        int partId = 0;
        int begin = 0;
        int i2 = 0;
        while (i2 < prefix.length()) {
            if (prefix.charAt(i2) == '.') {
                result[partId++] = prefix.substring(begin, i2);
                begin = i2 + 1;
            }
            ++i2;
        }
        result[partId] = prefix.substring(begin);
        return result;
    }
}

