/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.ArrayList;

public class CompilationTimer {
    private long initialTime;
    private long previousTime;
    private ArrayList<TimerEntry> entries = new ArrayList();
    private static TObjectLongHashMap<String> GLOBAL_TIMES = new TObjectLongHashMap();

    public CompilationTimer() {
        this.initialTime = this.previousTime = System.nanoTime();
    }

    public void phaseFinished(String phaseName) {
        long time = System.nanoTime();
        this.entries.add(new TimerEntry(phaseName, time - this.previousTime, time - this.initialTime));
        this.previousTime = time;
    }

    public void suspendTimer() {
        long time = System.nanoTime();
        this.initialTime -= time;
        this.previousTime -= time;
    }

    public void continueTimer() {
        long time = System.nanoTime();
        this.initialTime += time;
        this.previousTime += time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(String moduleName) {
        TObjectLongHashMap<String> tObjectLongHashMap = GLOBAL_TIMES;
        synchronized (tObjectLongHashMap) {
            System.out.println(moduleName);
            for (TimerEntry entry : this.entries) {
                long globalTime = GLOBAL_TIMES.adjustOrPutValue((Object)entry.phaseName, entry.time, entry.time);
                System.out.println("    " + entry.phaseName + " " + (double)entry.time * 1.0E-6 + "ms (cumulative: " + (double)entry.cumulativeTime * 1.0E-6 + "ms, global: " + (double)globalTime * 1.0E-6 + ")");
            }
        }
    }

    private static class TimerEntry {
        public final String phaseName;
        public final long time;
        public final long cumulativeTime;

        public TimerEntry(String phaseName, long time, long cumulativeTime) {
            this.phaseName = phaseName;
            this.time = time;
            this.cumulativeTime = cumulativeTime;
        }
    }
}

