/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import gnu.trove.map.hash.THashMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;
import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.compiler.testing.repository.TestRepository;
import org.simantics.scl.osgi.internal.BundleTestScriptRunnable;

@Component
public class BundleTestScriptRepository
implements TestRepository {
    Tracker tracker;
    THashMap<String, BundleTestScriptRunnable> testsRunnables = new THashMap();
    THashMap<Bundle, ArrayList<String>> testsPerBundle = new THashMap();

    @Activate
    public void activate(ComponentContext context) {
        this.tracker = new Tracker(context.getBundleContext());
        this.tracker.open();
    }

    @Deactivate
    public void deactivate() {
        this.tracker.close();
    }

    public void collectTests(Collection<TestRunnable> tests) {
        tests.addAll(this.testsRunnables.values());
    }

    class Tracker
    extends BundleTracker<Bundle> {
        public Tracker(BundleContext context) {
            super(context, -1, null);
        }

        public synchronized Bundle addingBundle(Bundle bundle, BundleEvent event) {
            Enumeration urls = bundle.findEntries("sclTests", "*.sts", true);
            if (urls != null) {
                ArrayList<String> modulesInThisBundle = new ArrayList<String>();
                while (urls.hasMoreElements()) {
                    URL url = (URL)urls.nextElement();
                    String path = url.getPath();
                    String testName = path.substring(10, path.length() - 4);
                    BundleTestScriptRepository.this.testsRunnables.put((Object)testName, (Object)new BundleTestScriptRunnable(testName, url));
                    modulesInThisBundle.add(testName);
                }
                BundleTestScriptRepository.this.testsPerBundle.put((Object)bundle, modulesInThisBundle);
            }
            return bundle;
        }

        public synchronized void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
            ArrayList moduleList = (ArrayList)BundleTestScriptRepository.this.testsPerBundle.get((Object)bundle);
            if (moduleList != null) {
                for (String moduleName : moduleList) {
                    BundleTestScriptRepository.this.testsRunnables.remove((Object)moduleName);
                }
            }
        }
    }
}

