/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example.old;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.parser.repository.DataValueRepository;


/**
 * In this DuckTyping example, one input is deserialized to three classes 
 * that look about the same.  
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class AdaptionExample1 {
	
	static final String INPUT = "(3, 6, 9)";

	static class DoubleVector {
		public DoubleVector() {}
		public double x, y, z;
	}
	static final Binding DoubleVectorBinding = Bindings.getBindingUnchecked( DoubleVector.class );
		
	static class FloatVector {
		public FloatVector() {}
		public float x, y, z;
	}
	static final Binding FloatVectorBinding = Bindings.getBindingUnchecked( FloatVector.class );
	
	static class IntVector {
		public IntVector() {}
		public int x, y, z;
	}
	static final Binding IntVectorBinding = Bindings.getBindingUnchecked( IntVector.class );
	
	public static void main(String[] args) throws Exception {
		
		// Read to DoubleVector		
		DataValueRepository repo = new DataValueRepository(); 
		DoubleVector doubleVector = (DoubleVector) DoubleVectorBinding.parseValue( INPUT, repo );
		System.out.printf("DoubleVector: %f, %f, %f\n", doubleVector.x, doubleVector.y, doubleVector.z);
				
		// Read to FloatVector
		FloatVector floatVector = (FloatVector) FloatVectorBinding.parseValue( INPUT, repo );
		System.out.printf("FloatVector: %f, %f, %f\n", floatVector.x, floatVector.y, floatVector.z);

		// Read to IntVector
		IntVector intVector = (IntVector) IntVectorBinding.parseValue( INPUT, repo );
		System.out.printf("IntVector: %d, %d, %d\n", intVector.x, intVector.y, intVector.z);
	}
	
}

