/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.html;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeConstructor;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.environment.filter.AcceptAllNamespaceFilter;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.markdown.internal.ExtensionNodeHandler;
import org.simantics.scl.compiler.markdown.internal.HtmlEscape;
import org.simantics.scl.compiler.markdown.internal.MarkdownParser;
import org.simantics.scl.compiler.markdown.nodes.CodeBlockNode;
import org.simantics.scl.compiler.markdown.nodes.DocumentNode;
import org.simantics.scl.compiler.markdown.nodes.HtmlNode;
import org.simantics.scl.compiler.markdown.nodes.Node;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLDocumentationExtensionNodeHandler
implements ExtensionNodeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLDocumentationExtensionNodeHandler.class);
    final ModuleRepository moduleRepository;
    final String documentationName;
    Failable<Module> relatedModule;
    THashMap<String, Failable<Module>> moduleCache = new THashMap();
    THashSet<String> documentedValues = new THashSet();
    THashSet<String> documentedClasses = new THashSet();
    THashSet<String> documentedTypeConstructors = new THashSet();

    public SCLDocumentationExtensionNodeHandler(ModuleRepository moduleRepository, String documentationName) {
        this.moduleRepository = moduleRepository;
        this.documentationName = documentationName;
    }

    @Override
    public DocumentNode expandBlock(String extension, String content) {
        if (extension.equals("value")) {
            String[] names = content.split(",");
            DocumentNode container = new DocumentNode();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!(name = name.trim()).isEmpty()) {
                    if (!this.documentedValues.add((Object)name)) {
                        LOGGER.warn("Value '" + name + "' has already been documented in " + this.documentationName + ".");
                    }
                    this.generateValueDocumentation(container, name);
                }
                ++n2;
            }
            return container;
        }
        if (extension.equals("class")) {
            String[] names = content.split(",");
            DocumentNode container = new DocumentNode();
            String[] stringArray = names;
            int n = names.length;
            int n3 = 0;
            while (n3 < n) {
                String name = stringArray[n3];
                if (!(name = name.trim()).isEmpty()) {
                    if (!this.documentedClasses.add((Object)name)) {
                        LOGGER.warn("Class '" + name + "' has already been documented in " + this.documentationName + ".");
                    }
                    this.generateClassDocumentation(container, name);
                }
                ++n3;
            }
            return container;
        }
        if (extension.equals("data")) {
            String[] names = content.split(",");
            DocumentNode container = new DocumentNode();
            String[] stringArray = names;
            int n = names.length;
            int n4 = 0;
            while (n4 < n) {
                String name = stringArray[n4];
                if (!(name = name.trim()).isEmpty()) {
                    if (!this.documentedTypeConstructors.add((Object)name)) {
                        LOGGER.warn("Type constructor '" + name + "' has already been documented in " + this.documentationName + ".");
                    }
                    this.generateDataDocumentation(container, name);
                }
                ++n4;
            }
            return container;
        }
        if (extension.equals("undocumented")) {
            Module module = this.getRelatedModule();
            if (module == null) {
                return null;
            }
            final ArrayList undocumentedValues = new ArrayList();
            module.findValuesForPrefix("", (NamespaceFilter)AcceptAllNamespaceFilter.INSTANCE, new TObjectProcedure<SCLValue>(){

                public boolean execute(SCLValue value) {
                    if (value.isPrivate()) {
                        return true;
                    }
                    String name = value.getName().name;
                    if (SCLDocumentationExtensionNodeHandler.this.documentedValues.contains((Object)name) || name.charAt(0) == '_' || name.contains("$") && Character.isAlphabetic(name.charAt(0))) {
                        return true;
                    }
                    undocumentedValues.add(name);
                    return true;
                }
            });
            Collections.sort(undocumentedValues);
            DocumentNode container = new DocumentNode();
            for (String name : undocumentedValues) {
                this.generateValueDocumentation(container, name);
            }
            return container;
        }
        return null;
    }

    private Module getRelatedModule() {
        if (this.relatedModule == null) {
            this.relatedModule = this.moduleRepository.getModule(this.documentationName);
            if (!this.relatedModule.didSucceed()) {
                LOGGER.warn("Couldn't load the module " + this.documentationName);
            }
        }
        if (this.relatedModule.didSucceed()) {
            return this.relatedModule.getResult();
        }
        return null;
    }

    private Module getModule(String moduleName) {
        Failable<Module> fm = (Failable<Module>)this.moduleCache.get((Object)moduleName);
        if (fm == null) {
            fm = this.moduleRepository.getModule(moduleName);
            this.moduleCache.put((Object)moduleName, fm);
            if (!fm.didSucceed()) {
                LOGGER.warn("Couldn't load the module " + moduleName);
            }
        }
        if (fm.didSucceed()) {
            return fm.getResult();
        }
        return null;
    }

    private void generateValueDocumentation(Node container, String name) {
        Module module;
        int p = name.lastIndexOf(47);
        if (p >= 0) {
            while (p > 0 && name.charAt(p - 1) == '/') {
                --p;
            }
            module = this.getModule(name.substring(0, p));
            name = name.substring(p + 1);
        } else {
            module = this.getRelatedModule();
        }
        if (module != null) {
            this.generateValueDocumentation(container, module, name);
        }
    }

    private void generateValueDocumentation(Node container, Module module, String name, TypeUnparsingContext tuc) {
        SCLValue value = module.getValue(name);
        if (value == null) {
            StringBuilder error = new StringBuilder();
            error.append("Didn't find the value '" + name + "'.");
            LOGGER.error(error.toString());
            container.addChild(new CodeBlockNode(error));
            return;
        }
        if (value.isPrivate()) {
            LOGGER.warn("Documentation " + this.documentationName + " refers to a private value " + name + ".");
        }
        StringBuilder signature = new StringBuilder();
        signature.append("<div id=\"").append(HtmlEscape.escape(name)).append("\" class=\"code-doc-box\"><div class=\"code value\">");
        char firstChar = name.charAt(0);
        if (!Character.isAlphabetic(firstChar) && firstChar != '_') {
            name = "(" + name + ")";
        }
        signature.append(HtmlEscape.escape(name)).append(" :: ");
        String typeStr = Types.removeForAll(value.getType(), new ArrayList<TVar>()).toString(tuc);
        signature.append(HtmlEscape.escape(typeStr));
        String moduleName = module.getName();
        if (!moduleName.equals(this.documentationName)) {
            signature.append(" <span class=\"greyed\">(").append(moduleName).append(")</span>");
        }
        signature.append("</div><div class=\"doc\">");
        container.addChild(new HtmlNode(signature));
        if (value.documentation != null) {
            MarkdownParser parser = new MarkdownParser();
            container.addChild(parser.parseDocument(value.documentation));
        } else {
            LOGGER.info(name);
        }
        container.addChild(new HtmlNode("</div></div>"));
    }

    private void generateValueDocumentation(Node container, Module module, String name) {
        this.generateValueDocumentation(container, module, name, new TypeUnparsingContext());
    }

    private void generateClassDocumentation(Node container, String name) {
        Module module;
        int p = name.lastIndexOf(47);
        if (p >= 0) {
            module = this.getModule(name.substring(0, p));
            name = name.substring(p + 1);
        } else {
            module = this.getRelatedModule();
        }
        if (module != null) {
            this.generateClassDocumentation(container, module, name);
        }
    }

    private void generateClassDocumentation(Node container, Module module, String name) {
        int n;
        TypeClass typeClass = module.getTypeClass(name);
        if (typeClass == null) {
            StringBuilder error = new StringBuilder();
            error.append("Didn't find the type class '" + name + "'.");
            LOGGER.error(error.toString());
            container.addChild(new CodeBlockNode(error));
            return;
        }
        TypeUnparsingContext tuc = new TypeUnparsingContext();
        StringBuilder signature = new StringBuilder();
        signature.append("<div id=\"class-").append(HtmlEscape.escape(name)).append("\" class=\"code-doc-box\"><div class=\"code class\">");
        signature.append("class ");
        if (typeClass.context.length > 0) {
            signature.append('(');
            boolean first = true;
            TPred[] tPredArray = typeClass.context;
            int n2 = typeClass.context.length;
            n = 0;
            while (n < n2) {
                TPred cx = tPredArray[n];
                if (first) {
                    first = false;
                } else {
                    signature.append(", ");
                }
                cx.toString(tuc, signature);
                ++n;
            }
            signature.append(") => ");
        }
        signature.append(name);
        TVar[] tVarArray = typeClass.parameters;
        n = typeClass.parameters.length;
        int n3 = 0;
        while (n3 < n) {
            TVar p = tVarArray[n3];
            signature.append(' ');
            p.toName(tuc, signature);
            ++n3;
        }
        signature.append("</div><div class=\"doc\">");
        container.addChild(new HtmlNode(signature));
        if (typeClass.documentation != null) {
            MarkdownParser parser = new MarkdownParser();
            container.addChild(parser.parseDocument(typeClass.documentation));
        } else {
            LOGGER.info(name);
        }
        for (String methodName : typeClass.methodNames) {
            if (!this.documentedValues.add((Object)methodName)) {
                LOGGER.warn("Method '" + methodName + "' has already been documented in " + this.documentationName + ".");
            }
            this.generateValueDocumentation(container, module, methodName, new TypeUnparsingContext(tuc));
        }
        container.addChild(new HtmlNode("</div></div>"));
    }

    private void generateDataDocumentation(Node container, String name) {
        Module module;
        int p = name.lastIndexOf(47);
        if (p >= 0) {
            module = this.getModule(name.substring(0, p));
            name = name.substring(p + 1);
        } else {
            module = this.getRelatedModule();
        }
        if (module != null) {
            this.generateDataDocumentation(container, module, name);
        }
    }

    private void generateDataDocumentation(Node container, Module module, String name) {
        String moduleName;
        int n;
        TypeDescriptor typeDescriptor = module.getTypeDescriptor(name);
        if (typeDescriptor == null) {
            StringBuilder error = new StringBuilder();
            error.append("Didn't find the type " + name + ".");
            container.addChild(new CodeBlockNode(error));
            return;
        }
        TypeUnparsingContext tuc = new TypeUnparsingContext();
        StringBuilder signature = new StringBuilder();
        signature.append("<div id=\"data-").append(HtmlEscape.escape(name)).append("\" class=\"code-doc-box\"><div class=\"code data\">");
        signature.append("data ");
        signature.append(typeDescriptor.name.name);
        if (typeDescriptor instanceof TypeConstructor) {
            TVar[] tVarArray = ((TypeConstructor)typeDescriptor).parameters;
            n = ((TypeConstructor)typeDescriptor).parameters.length;
            int n2 = 0;
            while (n2 < n) {
                TVar p = tVarArray[n2];
                signature.append(' ');
                p.toName(tuc, signature);
                ++n2;
            }
        }
        if (!(moduleName = module.getName()).equals(this.documentationName)) {
            signature.append(" <span class=\"greyed\">(").append(moduleName).append(")</span>");
        }
        signature.append("</div><div class=\"doc\">");
        container.addChild(new HtmlNode(signature));
        if (typeDescriptor.getDocumentation() != null) {
            MarkdownParser parser = new MarkdownParser();
            container.addChild(parser.parseDocument(typeDescriptor.getDocumentation()));
        } else {
            LOGGER.info(name);
        }
        if (typeDescriptor instanceof TypeConstructor) {
            Constructor[] constructorArray = ((TypeConstructor)typeDescriptor).constructors;
            int n3 = ((TypeConstructor)typeDescriptor).constructors.length;
            n = 0;
            while (n < n3) {
                Constructor constructor = constructorArray[n];
                if (!this.documentedValues.add((Object)constructor.name.name)) {
                    LOGGER.warn("Method '" + constructor.name.name + "' has already been documented in " + this.documentationName + ".");
                }
                this.generateValueDocumentation(container, module, constructor.name.name, new TypeUnparsingContext(tuc));
                ++n;
            }
        }
        container.addChild(new HtmlNode("</div></div>"));
    }
}

