/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.types;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class TForAllAst
extends TypeAst {
    public final String[] vars;
    public final TypeAst type;

    public TForAllAst(String[] vars, TypeAst type) {
        this.vars = vars;
        this.type = type;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("forall");
        String[] stringArray = this.vars;
        int n = this.vars.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            b.append(' ');
            b.append(var);
            ++n2;
        }
        b.append(". ");
        this.type.toString(b);
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        context.unify(this.location, Kinds.STAR, expectedKind);
        TVar[] oldVars = new TVar[this.vars.length];
        int i = 0;
        while (i < this.vars.length) {
            oldVars[i] = context.pushTypeVar(this.vars[i]);
            ++i;
        }
        Type result = this.type.toType(context, Kinds.STAR);
        int i2 = this.vars.length - 1;
        while (i2 >= 0) {
            result = Types.forAll(context.popTypeVar(this.vars[i2], oldVars[i2]), result);
            --i2;
        }
        return result;
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        TVar[] oldVars = new TVar[this.vars.length];
        int i = 0;
        while (i < this.vars.length) {
            oldVars[i] = context.push(this.vars[i]);
            ++i;
        }
        Type result = this.type.toType(context);
        int i2 = this.vars.length - 1;
        while (i2 >= 0) {
            result = Types.forAll(context.pop(this.vars[i2], oldVars[i2]), result);
            --i2;
        }
        return result;
    }

    @Override
    public int getPrecedence() {
        return 2;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap, TIntHashSet set) {
        this.type.collectReferences(typeNameMap, set);
    }
}

