/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.declarations;

import org.simantics.scl.compiler.internal.parsing.declarations.DeclarationAst;

public class DDocumentationAst
extends DeclarationAst {
    public final String documentation;

    public DDocumentationAst(String documentation) {
        this.documentation = DDocumentationAst.cleanUp(documentation);
    }

    @Override
    public void toString(int indentation, StringBuilder b) {
        int i = 0;
        while (i < indentation) {
            b.append("    ");
            ++i;
        }
        b.append("\"\"\"\n");
        b.append(this.documentation);
        b.append("\"\"\"\n");
    }

    private static String cleanUp(String documentation) {
        int end = documentation.length();
        while (end > 0) {
            char c = documentation.charAt(end - 1);
            if (c != ' ' && c != '\n') break;
            --end;
        }
        int begin = 0;
        int i = 0;
        while (i < end) {
            char c = documentation.charAt(i);
            if (c == '\n') {
                begin = i + 1;
            } else if (c != ' ') break;
            ++i;
        }
        int lineStart = begin;
        int commonIndentation = Integer.MAX_VALUE;
        int i2 = begin;
        while (i2 < end) {
            char c = documentation.charAt(i2);
            if (c == '\n') {
                lineStart = i2 + 1;
            } else if (lineStart >= 0 && c != ' ') {
                int indentation = i2 - lineStart;
                if ((commonIndentation = Math.min(commonIndentation, indentation)) == 0) {
                    if (begin == 0 && end == documentation.length()) {
                        return documentation;
                    }
                    return documentation.substring(begin, end);
                }
                lineStart = -1;
            }
            ++i2;
        }
        StringBuilder result = new StringBuilder();
        int charsToSkip = commonIndentation;
        int i3 = begin;
        while (i3 < end) {
            char c = documentation.charAt(i3);
            if (c == '\n') {
                result.append(c);
                charsToSkip = commonIndentation;
            } else if (charsToSkip > 0) {
                --charsToSkip;
            } else {
                result.append(c);
            }
            ++i3;
        }
        return result.toString();
    }
}

