/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.utils;

public abstract class StronglyConnectedComponents {
    private int[] id;
    private int[] lowId;
    private boolean[] inStack;
    private int[] stack;
    private int stackPos = 0;
    private int currentId = 0;

    public StronglyConnectedComponents(int size) {
        this.id = new int[size];
        this.lowId = new int[size];
        this.inStack = new boolean[size];
        this.stack = new int[size];
        int i = 0;
        while (i < this.id.length) {
            this.id[i] = -1;
            ++i;
        }
    }

    public void findComponents() {
        int i = 0;
        while (i < this.id.length) {
            if (this.id[i] < 0) {
                this.visit(i);
            }
            ++i;
        }
    }

    private void visit(int v) {
        int vId;
        this.id[v] = vId = this.currentId++;
        int tempLowId = vId;
        int initialStackPos = this.stackPos;
        this.stack[this.stackPos++] = v;
        this.inStack[v] = true;
        int[] nArray = this.findDependencies(v);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int u = nArray[n2];
            int uId = this.id[u];
            if (uId < 0) {
                this.visit(u);
                tempLowId = Math.min(tempLowId, this.lowId[u]);
            } else if (this.inStack[u]) {
                tempLowId = Math.min(tempLowId, uId);
            }
            ++n2;
        }
        this.lowId[v] = tempLowId;
        if (vId == tempLowId) {
            int[] component = new int[this.stackPos - initialStackPos];
            while (this.stackPos > initialStackPos) {
                int e;
                component[this.stackPos - initialStackPos] = e = this.stack[--this.stackPos];
                this.inStack[e] = false;
            }
            this.reportComponent(component);
        }
    }

    protected abstract int[] findDependencies(int var1);

    protected abstract void reportComponent(int[] var1);
}

