/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.ssa;

import java.util.ArrayList;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.Printable;
import org.simantics.scl.compiler.internal.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSALambdaLiftingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.internal.codegen.utils.ValRefVisitor;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public abstract class SSAStatement
implements Printable {
    SSABlock parent;
    SSAStatement prev;
    SSAStatement next;
    public int lineNumber = -2;

    public void detach() {
        if (this.prev == null) {
            this.parent.firstStatement = this.next;
        } else {
            this.prev.next = this.next;
        }
        if (this.next == null) {
            this.parent.lastStatement = this.prev;
        } else {
            this.next.prev = this.prev;
        }
    }

    public abstract void generateCode(MethodBuilder var1);

    public abstract void validate(SSAValidationContext var1);

    public void simplify(SSASimplificationContext context) {
    }

    public abstract void destroy();

    public SSABlock getParent() {
        return this.parent;
    }

    public SSAStatement getPrev() {
        return this.prev;
    }

    public void setAsLastStatement() {
        this.next = null;
        this.parent.lastStatement = this;
    }

    public SSAStatement getNext() {
        return this.next;
    }

    public void remove() {
        this.detach();
        this.destroy();
    }

    public String toString() {
        PrintingContext context = new PrintingContext();
        this.toString(context);
        return context.toString();
    }

    public void markGenerateOnFly() {
    }

    public abstract SSAStatement copy(CopyContext var1);

    public abstract void replace(TVar[] var1, Type[] var2);

    public abstract void addBoundVariablesTo(SSAValidationContext var1);

    public abstract void collectFreeVariables(SSAFunction var1, ArrayList<ValRef> var2);

    public SSAFunction getParentFunction() {
        return this.parent.parent;
    }

    public void lambdaLift(SSALambdaLiftingContext context) {
    }

    public void insertBefore(SSAStatement statement) {
        this.next = statement;
        this.prev = statement.prev;
        this.parent = statement.parent;
        if (this.prev == null) {
            this.parent.firstStatement = this;
        } else {
            this.prev.next = this;
        }
        statement.prev = this;
    }

    public void insertAfter(SSAStatement statement) {
        this.prev = statement;
        this.next = statement.next;
        this.parent = statement.parent;
        if (this.next == null) {
            this.parent.lastStatement = this;
        } else {
            this.next.prev = this;
        }
        statement.next = this;
    }

    public void replaceByApply(ValRef valRef, Val function, Type[] typeParameters, Val[] parameters) {
        BoundVar target = new BoundVar(valRef.getBinding().getType());
        new LetApply(target, Types.NO_EFFECTS, function.createOccurrence(typeParameters), ValRef.createOccurrences(parameters)).insertBefore(this);
        valRef.replaceBy(target);
    }

    public void prepare(MethodBuilder mb) {
    }

    public abstract void forValRefs(ValRefVisitor var1);

    public abstract void cleanup();

    public void detachThisAndSuccessors() {
        this.parent.lastStatement = this.prev;
        if (this.prev == null) {
            this.parent.firstStatement = null;
        } else {
            this.prev.next = null;
        }
    }
}

