/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.environment;

import gnu.trove.procedure.TObjectProcedure;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Namespace;
import org.simantics.scl.compiler.environment.filter.AcceptAllNamespaceFilter;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserImpl;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;

public class Environments {
    private static final NamespaceValueAccessor<SCLValue> getValue = new NamespaceValueAccessor<SCLValue>(){

        @Override
        public SCLValue get(Namespace ns, String name) throws AmbiguousNameException {
            return ns.getValue(name);
        }
    };
    private static final NamespaceValueAccessor<SCLRelation> getRelation = new NamespaceValueAccessor<SCLRelation>(){

        @Override
        public SCLRelation get(Namespace ns, String name) throws AmbiguousNameException {
            return ns.getRelation(name);
        }
    };
    private static final NamespaceValueAccessor<MappingRelation> getMappingRelation = new NamespaceValueAccessor<MappingRelation>(){

        @Override
        public MappingRelation get(Namespace ns, String name) throws AmbiguousNameException {
            return ns.getMappingRelation(name);
        }
    };
    private static final NamespaceValueAccessor<TransformationRule> getRule = new NamespaceValueAccessor<TransformationRule>(){

        @Override
        public TransformationRule get(Namespace ns, String name) throws AmbiguousNameException {
            return ns.getRule(name);
        }
    };
    private static final NamespaceValueAccessor<SCLEntityType> getEntityType = new NamespaceValueAccessor<SCLEntityType>(){

        @Override
        public SCLEntityType get(Namespace ns, String name) throws AmbiguousNameException {
            return ns.getEntityType(name);
        }
    };
    private static final NamespaceValueAccessor<TypeDescriptor> getTypeDescriptor = new NamespaceValueAccessor<TypeDescriptor>(){

        @Override
        public TypeDescriptor get(Namespace ns, String name) throws AmbiguousNameException {
            return ns.getTypeDescriptor(name);
        }
    };
    private static final NamespaceValueAccessor<EffectConstructor> getEffectConstructor = new NamespaceValueAccessor<EffectConstructor>(){

        @Override
        public EffectConstructor get(Namespace ns, String name) throws AmbiguousNameException {
            return ns.getEffectConstructor(name);
        }
    };
    private static final NamespaceValueAccessor<TypeClass> getTypeClass = new NamespaceValueAccessor<TypeClass>(){

        @Override
        public TypeClass get(Namespace ns, String name) throws AmbiguousNameException {
            return ns.getTypeClass(name);
        }
    };
    private static final NamespaceValueAccessor<CHRRuleset> getRuleset = new NamespaceValueAccessor<CHRRuleset>(){

        @Override
        public CHRRuleset get(Namespace ns, String name) throws AmbiguousNameException {
            return ns.getRuleset(name);
        }
    };

    public static SCLValue getValue(Environment environment, String localName) throws AmbiguousNameException {
        return Environments.getEnvironmentEntry(environment, localName, getValue);
    }

    public static SCLRelation getRelation(Environment environment, String localName) throws AmbiguousNameException {
        return Environments.getEnvironmentEntry(environment, localName, getRelation);
    }

    public static MappingRelation getMappingRelation(Environment environment, String localName) throws AmbiguousNameException {
        return Environments.getEnvironmentEntry(environment, localName, getMappingRelation);
    }

    public static TransformationRule getRule(Environment environment, String localName) throws AmbiguousNameException {
        return Environments.getEnvironmentEntry(environment, localName, getRule);
    }

    public static SCLEntityType getEntityType(Environment environment, String localName) throws AmbiguousNameException {
        return Environments.getEnvironmentEntry(environment, localName, getEntityType);
    }

    public static TypeDescriptor getTypeDescriptor(Environment environment, String localName) throws AmbiguousNameException {
        return Environments.getEnvironmentEntry(environment, localName, getTypeDescriptor);
    }

    public static EffectConstructor getEffectConstructor(Environment environment, String localName) throws AmbiguousNameException {
        return Environments.getEnvironmentEntry(environment, localName, getEffectConstructor);
    }

    public static TypeClass getTypeClass(Environment environment, String localName) throws AmbiguousNameException {
        return Environments.getEnvironmentEntry(environment, localName, getTypeClass);
    }

    public static CHRRuleset getRuleset(Environment environment, String localName) throws AmbiguousNameException {
        return Environments.getEnvironmentEntry(environment, localName, getRuleset);
    }

    public static Name getValueName(Environment environment, String localName) throws AmbiguousNameException {
        SCLValue value = Environments.getValue(environment, localName);
        if (value == null) {
            return null;
        }
        return value.getName();
    }

    public static TCon getTypeDescriptorName(Environment environment, String localName) throws AmbiguousNameException {
        TypeDescriptor typeDescriptor = Environments.getTypeDescriptor(environment, localName);
        if (typeDescriptor == null) {
            return null;
        }
        return typeDescriptor.name;
    }

    public static TCon getEffectConstructorName(Environment environment, String localName) throws AmbiguousNameException {
        EffectConstructor effectConstructor = Environments.getEffectConstructor(environment, localName);
        if (effectConstructor == null) {
            return null;
        }
        return effectConstructor.name;
    }

    public static TCon getTypeClassName(Environment environment, String localName) throws AmbiguousNameException {
        TypeClass typeClass = Environments.getTypeClass(environment, localName);
        if (typeClass == null) {
            return null;
        }
        return typeClass.name;
    }

    public static Type getType(Environment environment, String typeText) throws SCLExpressionCompilationException {
        SCLParserImpl parser = new SCLParserImpl(new StringReader(typeText));
        CompilationContext compilationContext = new CompilationContext();
        compilationContext.environment = environment;
        try {
            TypeAst typeAst = (TypeAst)parser.parseType();
            TypeTranslationContext context = new TypeTranslationContext(compilationContext);
            Type type = context.toType(typeAst);
            if (compilationContext.errorLog.hasNoErrors()) {
                return type;
            }
        }
        catch (SCLSyntaxErrorException e) {
            compilationContext.errorLog.log(e.location, e.getMessage());
        }
        catch (Exception e) {
            compilationContext.errorLog.log(e);
        }
        throw new SCLExpressionCompilationException(compilationContext.errorLog.getErrors());
    }

    public static void findValuesForPrefix(Environment environment, String prefix, TObjectProcedure<SCLValue> proc) {
        Environments.findValuesForPrefix(environment.getLocalNamespace(), prefix, proc);
    }

    public static List<SCLValue> findValuesForPrefix(Environment environment, String prefix) {
        final ArrayList<SCLValue> result = new ArrayList<SCLValue>();
        Environments.findValuesForPrefix(environment, prefix, new TObjectProcedure<SCLValue>(){

            public boolean execute(SCLValue value) {
                result.add(value);
                return true;
            }
        });
        return result;
    }

    public static void findValuesForPrefix(Namespace namespace, String prefix, TObjectProcedure<SCLValue> proc) {
        int p = prefix.indexOf(46);
        if (p > 0) {
            Namespace childNamespace = namespace.getNamespace(prefix.substring(0, p));
            if (childNamespace != null) {
                Environments.findValuesForPrefix(childNamespace, prefix.substring(p + 1), proc);
            } else {
                namespace.findValuesForPrefix(prefix, AcceptAllNamespaceFilter.INSTANCE, proc);
            }
        } else {
            namespace.findValuesForPrefix(prefix, AcceptAllNamespaceFilter.INSTANCE, proc);
        }
    }

    public static List<TCon> findTypesForPrefix(Environment environment, String prefix) {
        final ArrayList<TCon> results = new ArrayList<TCon>();
        Environments.findTypesForPrefix(environment.getLocalNamespace(), prefix, new Consumer<TCon>(){

            @Override
            public void accept(TCon tcon) {
                results.add(tcon);
            }
        });
        return results;
    }

    public static void findTypesForPrefix(Namespace namespace, String prefix, Consumer<TCon> consumer) {
        int p = prefix.indexOf(46);
        if (p > 0) {
            Namespace childNamespace = namespace.getNamespace(prefix.substring(0, p));
            if (childNamespace != null) {
                Environments.findTypesForPrefix(childNamespace, prefix.substring(p + 1), consumer);
            }
        } else {
            namespace.findTypesForPrefix(prefix, AcceptAllNamespaceFilter.INSTANCE, consumer);
        }
    }

    private static <T> T getEnvironmentEntry(Environment environment, String localName, NamespaceValueAccessor<T> accessor) throws AmbiguousNameException {
        Namespace namespace = environment.getLocalNamespace();
        int curPos = 0;
        int pos;
        while ((pos = localName.indexOf(46, curPos)) >= 0) {
            Namespace newNamespace = namespace.getNamespace(localName.substring(curPos, pos));
            if (newNamespace == null) {
                return accessor.get(namespace, localName.substring(curPos));
            }
            namespace = newNamespace;
            curPos = pos + 1;
        }
        return accessor.get(namespace, localName.substring(curPos));
    }

    private static interface NamespaceValueAccessor<T> {
        public T get(Namespace var1, String var2) throws AmbiguousNameException;
    }
}

