/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRQuery;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.plan.CHRSearchPlan;
import org.simantics.scl.compiler.elaboration.chr.planning.QueryPlanningContext;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EAsPattern;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.printing.ExpressionToStringVisitor;
import org.simantics.scl.compiler.elaboration.expressions.visitors.StandardExpressionVisitor;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class CHRRule
extends Symbol {
    public CHRRuleset parentRuleset;
    public int priority;
    public CHRQuery head;
    public CHRQuery body;
    public Variable[] existentialVariables;
    public int lastPriorityExecuted;
    public ArrayList<CHRSearchPlan> plans = new ArrayList();
    public String containerClassName;
    private static final Object NEVER_USED = new Object();

    public CHRRule(long location, CHRQuery head, CHRQuery body, Variable[] existentialVariables) {
        this.location = location;
        this.head = head;
        this.body = body;
        this.existentialVariables = existentialVariables;
    }

    public CHRRule(long location, CHRQuery head, CHRQuery body) {
        this(location, head, body, null);
    }

    public void resolve(TranslationContext context) {
        context.pushExistentialFrame();
        this.head.resolve(context);
        context.disallowNewExistentials();
        this.body.resolve(context);
        this.existentialVariables = context.popExistentialFrame();
        this.warnForExistentialsUsedOnlyOnce(context);
    }

    private void warnForExistentialsUsedOnlyOnce(TranslationContext context) {
        final HashMap<Variable, Object> usageCount = new HashMap<Variable, Object>(this.existentialVariables.length);
        Variable[] variableArray = this.existentialVariables;
        int n = this.existentialVariables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            if (!var.getName().equals("_")) {
                usageCount.put(var, NEVER_USED);
            }
            ++n2;
        }
        StandardExpressionVisitor visitor = new StandardExpressionVisitor(){

            private void handle(Expression expression, Variable variable) {
                Object object = usageCount.remove(variable);
                if (object == NEVER_USED) {
                    usageCount.put(variable, expression);
                }
            }

            @Override
            public void visit(EVariable expression) {
                if (expression.variable != null) {
                    this.handle(expression, expression.variable);
                }
            }

            @Override
            public void visit(EAsPattern expression) {
                expression.pattern.accept(this);
                this.handle(expression, expression.var);
            }
        };
        this.head.accept(visitor);
        this.body.accept(visitor);
        usageCount.forEach((variable, expression_) -> {
            if (!(expression_ instanceof Expression)) {
                return;
            }
            Expression expression = (Expression)expression_;
            if (context.isExpandedFromWildcard(expression)) {
                return;
            }
            context.getErrorLog().logWarning(expression.location, "Existential variable " + variable.getName() + " is referred only once. Replace by _ if this is a wildcard.");
        });
    }

    public void checkType(TypingContext context) {
        Variable[] variableArray = this.existentialVariables;
        int n = this.existentialVariables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            variable.setType(Types.metaVar(Kinds.STAR));
            ++n2;
        }
        this.head.checkType(context);
        this.body.checkType(context);
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.head.collectVars(allVars, vars);
        this.body.collectVars(allVars, vars);
    }

    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.head.setLocationDeep(loc);
            this.body.setLocationDeep(loc);
        }
    }

    public void simplify(SimplificationContext context) {
        this.head.simplify(context);
        this.body.simplify(context);
    }

    public void compile(CompilationContext compilationContext, CHRConstraint initConstraint) {
        boolean hasLocalActiveLiteral = false;
        int i = 0;
        while (i < this.head.literals.length) {
            CHRLiteral literal = this.head.literals[i];
            if (!literal.passive) {
                CHRConstraint constraint = (CHRConstraint)literal.relation;
                QueryPlanningContext context = new QueryPlanningContext(compilationContext, this.existentialVariables);
                Variable activeFact = new Variable("activeFact", constraint.factType);
                if (!this.head.createQueryPlan(context, new EVariable(activeFact), i, initConstraint)) {
                    return;
                }
                this.body.createEnforcePlan(context, this.priority);
                this.addPlan(new CHRSearchPlan(constraint, activeFact, context.getPlanOps()));
                if (constraint.parentRuleset == this.parentRuleset) {
                    hasLocalActiveLiteral = true;
                }
            }
            ++i;
        }
        if (!hasLocalActiveLiteral) {
            QueryPlanningContext context = new QueryPlanningContext(compilationContext, this.existentialVariables);
            Variable activeFact = new Variable("activeFact", initConstraint.factType);
            if (!this.head.createQueryPlan(context, new EVariable(activeFact), -1, initConstraint)) {
                return;
            }
            this.body.createEnforcePlan(context, this.priority);
            this.addPlan(new CHRSearchPlan(initConstraint, activeFact, context.getPlanOps()));
        }
    }

    private void addPlan(CHRSearchPlan plan) {
        this.plans.add(plan);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        ExpressionToStringVisitor visitor = new ExpressionToStringVisitor(b);
        visitor.visit(this);
        return b.toString();
    }
}

