/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.compilation.TypeCheckingScheduler;
import org.simantics.scl.compiler.compilation.TypeInferableDefinition;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EAmbiguous;
import org.simantics.scl.compiler.elaboration.expressions.EPlaceholder;
import org.simantics.scl.compiler.elaboration.expressions.ETransformation;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.relations.ConcreteRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.elaboration.constraints.Constraint;
import org.simantics.scl.compiler.internal.elaboration.constraints.ConstraintEnvironment;
import org.simantics.scl.compiler.internal.elaboration.constraints.ConstraintSolver;
import org.simantics.scl.compiler.internal.elaboration.constraints.ExpressionAugmentation;
import org.simantics.scl.compiler.internal.elaboration.constraints.ReducedConstraints;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.Polarity;

public class TypeChecking {
    final CompilationContext compilationContext;
    final Environment environment;
    final ConcreteModule module;
    ConstraintEnvironment ce;
    TypeCheckingScheduler scheduler;

    public TypeChecking(CompilationContext compilationContext, ConcreteModule module) {
        this.compilationContext = compilationContext;
        this.environment = compilationContext.environment;
        this.module = module;
    }

    private void typeCheckValues() {
        for (final SCLValue value : this.module.getValues()) {
            if (value.getExpression() == null) continue;
            if (value.getType() == null) {
                this.scheduler.addTypeInferableDefinition(new TypeInferableDefinition(){
                    ArrayList<EPlaceholder> recursiveReferences;
                    ArrayList<EVariable> constraintDemand;
                    ArrayList<Variable> freeEvidence;
                    ArrayList<Constraint> unsolvedConstraints;

                    @Override
                    public long getLocation() {
                        return value.getExpression().getLocation();
                    }

                    @Override
                    public Collection<Object> getDefinedObjects() {
                        return Collections.singleton(value);
                    }

                    @Override
                    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
                        value.getExpression().collectRefs(allRefs, refs);
                    }

                    @Override
                    public void initializeTypeChecking(TypingContext context) {
                        value.setType(Types.metaVar(Kinds.STAR));
                        context.recursiveValues.add((Object)value);
                    }

                    @Override
                    public void checkType(TypingContext context) {
                        this.recursiveReferences = new ArrayList();
                        context.recursiveReferences = this.recursiveReferences;
                        Expression expression = value.getExpression();
                        context.pushEffectUpperBound(expression.location, Types.PROC);
                        expression = expression.checkType(context, value.getType());
                        context.popEffectUpperBound();
                        for (EAmbiguous overloaded : context.overloadedExpressions) {
                            overloaded.assertResolved(TypeChecking.this.compilationContext.errorLog);
                        }
                        value.setExpression(expression);
                        ArrayList<EVariable> constraintDemand = context.getConstraintDemand();
                        if (!constraintDemand.isEmpty()) {
                            this.constraintDemand = constraintDemand;
                            context.resetConstraintDemand();
                        }
                        expression.getType().addPolarity(Polarity.POSITIVE);
                    }

                    @Override
                    public void solveConstraints() {
                        if (this.constraintDemand != null) {
                            Expression expression = value.getExpression();
                            ReducedConstraints red = ConstraintSolver.solve(TypeChecking.this.ce, new ArrayList<TPred>(0), this.constraintDemand, true);
                            expression = ExpressionAugmentation.augmentSolved(red.solvedConstraints, expression);
                            value.setExpression(expression);
                            value.setType(expression.getType());
                            for (Constraint c : red.unsolvedConstraints) {
                                if (!c.constraint.isGround()) continue;
                                TypeChecking.this.compilationContext.errorLog.log(c.getDemandLocation(), "There is no instance for <" + c.constraint + ">.");
                            }
                            ArrayList<Variable> fe = new ArrayList<Variable>(red.unsolvedConstraints.size());
                            for (Constraint c : red.unsolvedConstraints) {
                                fe.add(c.evidence);
                            }
                            this.unsolvedConstraints = red.unsolvedConstraints;
                            this.freeEvidence = fe;
                        } else {
                            value.setExpression(value.getExpression().decomposeMatching());
                            this.freeEvidence = new ArrayList(0);
                        }
                    }

                    @Override
                    public void collectFreeTypeVariables(THashSet<TVar> varSet) {
                        Type type = value.getType();
                        type = type.convertMetaVarsToVars();
                        value.setType(type);
                        varSet.addAll(Types.freeVars(type));
                    }

                    @Override
                    public ArrayList<Variable> getFreeEvidence() {
                        return this.freeEvidence;
                    }

                    @Override
                    public ArrayList<Constraint> getUnsolvedConstraints() {
                        return this.unsolvedConstraints;
                    }

                    @Override
                    public void injectEvidence(TVar[] vars, TPred[] constraints) {
                        THashMap indexedEvidence = new THashMap(this.freeEvidence.size());
                        for (Variable v : this.freeEvidence) {
                            indexedEvidence.put((Object)((TPred)v.getType()), (Object)v);
                        }
                        this.freeEvidence.clear();
                        TPred[] tPredArray = constraints;
                        int n = constraints.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TPred c = tPredArray[n2];
                            Variable var = (Variable)indexedEvidence.get((Object)c);
                            if (var == null) {
                                var = new Variable("evX");
                                var.setType(c);
                                this.freeEvidence.add(var);
                            }
                            this.freeEvidence.add(var);
                            ++n2;
                        }
                        value.setExpression(Expressions.lambda((Type)Types.NO_EFFECTS, this.freeEvidence, value.getExpression()).closure(vars));
                        value.setType(Types.forAll(vars, Types.constrained(constraints, value.getType())));
                        for (EPlaceholder ref : this.recursiveReferences) {
                            ref.expression = Expressions.loc(ref.expression.location, Expressions.apply(Types.NO_EFFECTS, Expressions.applyTypes(ref.expression, vars), Expressions.vars(this.freeEvidence)));
                        }
                    }
                });
                continue;
            }
            this.scheduler.addPostTypeCheckingRunnable(new Runnable(){

                @Override
                public void run() {
                    Type type = value.getType();
                    Expression expression = value.getExpression();
                    int errorCountBeforeTypeChecking = TypeChecking.this.compilationContext.errorLog.getErrorCount();
                    int functionArity = expression.getSyntacticFunctionArity();
                    try {
                        ArrayList<EVariable> demands;
                        int typeArity;
                        ArrayList<TVar> vars = new ArrayList<TVar>();
                        type = Types.removeForAll(type, vars);
                        ArrayList<TPred> givenConstraints = new ArrayList<TPred>();
                        type = Types.removePred(type, givenConstraints);
                        TypingContext context = new TypingContext(TypeChecking.this.compilationContext);
                        context.pushEffectUpperBound(expression.location, Types.PROC);
                        expression = expression.checkType(context, type);
                        context.popEffectUpperBound();
                        for (EAmbiguous overloaded : context.overloadedExpressions) {
                            overloaded.assertResolved(TypeChecking.this.compilationContext.errorLog);
                        }
                        expression.getType().addPolarity(Polarity.POSITIVE);
                        context.solveSubsumptions(expression.getLocation());
                        if (TypeChecking.this.compilationContext.errorLog.getErrorCount() != errorCountBeforeTypeChecking && (typeArity = Types.getArity(type)) != functionArity) {
                            TypeChecking.this.compilationContext.errorLog.logWarning(value.definitionLocation, "Possible problem: type declaration has " + typeArity + " parameter types, but function definition has " + functionArity + " parameters.");
                        }
                        if (!(demands = context.getConstraintDemand()).isEmpty() || !givenConstraints.isEmpty()) {
                            ReducedConstraints red = ConstraintSolver.solve(TypeChecking.this.ce, givenConstraints, demands, true);
                            givenConstraints.clear();
                            for (Constraint c : red.unsolvedConstraints) {
                                TypeChecking.this.compilationContext.errorLog.log(c.getDemandLocation(), "Constraint <" + c.constraint + "> is not given and cannot be derived.");
                            }
                            if (TypeChecking.this.compilationContext.errorLog.hasNoErrors()) {
                                expression = ExpressionAugmentation.augmentSolved(red.solvedConstraints, expression);
                                expression = ExpressionAugmentation.augmentUnsolved(red.givenConstraints, expression);
                            }
                        } else if (TypeChecking.this.compilationContext.errorLog.hasNoErrors()) {
                            expression = expression.decomposeMatching();
                        }
                        expression = expression.closure(vars.toArray(new TVar[vars.size()]));
                        value.setExpression(expression);
                    }
                    catch (Exception e) {
                        TypeChecking.this.compilationContext.errorLog.log(expression.location, e);
                    }
                }
            });
        }
    }

    private void typeCheckRelations() {
        for (SCLRelation relation_ : this.module.getRelations()) {
            if (!(relation_ instanceof ConcreteRelation)) continue;
            final ConcreteRelation relation = (ConcreteRelation)relation_;
            this.scheduler.addTypeInferableDefinition(new TypeInferableDefinition(){

                @Override
                public void initializeTypeChecking(TypingContext context) {
                    Variable[] variableArray = relation.parameters;
                    int n = relation.parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Variable parameter = variableArray[n2];
                        TMetaVar type = Types.metaVar(Kinds.STAR);
                        ((Type)type).addPolarity(Polarity.BIPOLAR);
                        parameter.setType(type);
                        ++n2;
                    }
                }

                @Override
                public void solveConstraints() {
                }

                @Override
                public void injectEvidence(TVar[] vars, TPred[] constraints) {
                    relation.typeVariables = vars;
                }

                @Override
                public ArrayList<Constraint> getUnsolvedConstraints() {
                    return new ArrayList<Constraint>(0);
                }

                @Override
                public long getLocation() {
                    return relation.location;
                }

                @Override
                public ArrayList<Variable> getFreeEvidence() {
                    return new ArrayList<Variable>(0);
                }

                @Override
                public Collection<Object> getDefinedObjects() {
                    return Collections.singleton(relation);
                }

                @Override
                public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
                    for (ConcreteRelation.QuerySection section : relation.getSections()) {
                        section.query.collectRefs(allRefs, refs);
                    }
                }

                @Override
                public void collectFreeTypeVariables(THashSet<TVar> varSet) {
                    Variable[] variableArray = relation.parameters;
                    int n = relation.parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Variable parameter = variableArray[n2];
                        Type parameterType = parameter.getType().convertMetaVarsToVars();
                        varSet.addAll(Types.freeVars(parameterType));
                        ++n2;
                    }
                }

                @Override
                public void checkType(TypingContext context) {
                    for (ConcreteRelation.QuerySection section : relation.getSections()) {
                        section.effect = Types.metaVar(Kinds.EFFECT);
                        context.pushEffectUpperBound(relation.location, section.effect);
                        Variable[] variableArray = section.existentials;
                        int n = section.existentials.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Variable variable = variableArray[n2];
                            variable.setType(Types.metaVar(Kinds.STAR));
                            ++n2;
                        }
                        section.query.checkType(context);
                        context.popEffectUpperBound();
                    }
                    if (relation.enforceSection != null) {
                        relation.writingEffect = Types.metaVar(Kinds.EFFECT);
                        context.pushEffectUpperBound(relation.location, relation.writingEffect);
                        relation.enforceSection.checkType(context);
                        context.popEffectUpperBound();
                    }
                }
            });
        }
    }

    public void typeCheck() {
        this.ce = new ConstraintEnvironment(this.compilationContext);
        this.scheduler = new TypeCheckingScheduler(this.compilationContext);
        this.typeCheckValues();
        this.typeCheckRelations();
        this.typeCheckRules();
        this.scheduler.schedule();
    }

    private void typeCheckRules() {
        this.scheduler.addTypeInferableDefinition(new TypeInferableDefinition(){

            @Override
            public void solveConstraints() {
            }

            @Override
            public void injectEvidence(TVar[] vars, TPred[] constraints) {
            }

            @Override
            public void initializeTypeChecking(TypingContext context) {
            }

            @Override
            public ArrayList<Constraint> getUnsolvedConstraints() {
                return new ArrayList<Constraint>(0);
            }

            @Override
            public long getLocation() {
                return 0L;
            }

            @Override
            public ArrayList<Variable> getFreeEvidence() {
                return new ArrayList<Variable>(0);
            }

            @Override
            public Collection<Object> getDefinedObjects() {
                return Collections.singleton(ETransformation.TRANSFORMATION_RULES_TYPECHECKED);
            }

            @Override
            public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
                for (TransformationRule rule : TypeChecking.this.module.getRules()) {
                    Iterator iterator = rule.sections.values().iterator();
                    while (iterator.hasNext()) {
                        Query[] queries;
                        Query[] queryArray = queries = (Query[])iterator.next();
                        int n = queries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Query query = queryArray[n2];
                            query.collectRefs(allRefs, refs);
                            ++n2;
                        }
                    }
                }
            }

            @Override
            public void collectFreeTypeVariables(THashSet<TVar> varSet) {
            }

            @Override
            public void checkType(TypingContext context) {
                for (TransformationRule rule : TypeChecking.this.module.getRules()) {
                    context.pushEffectUpperBound(rule.location, Types.metaVar(Kinds.EFFECT));
                    rule.checkType(context);
                    rule.setEffect(Types.canonical(context.popEffectUpperBound()));
                }
            }
        });
        if (!this.module.getMappingRelations().isEmpty()) {
            this.scheduler.addPostTypeCheckingRunnable(new Runnable(){

                @Override
                public void run() {
                    block0: for (MappingRelation mappingRelation : TypeChecking.this.module.getMappingRelations()) {
                        Type[] typeArray = mappingRelation.parameterTypes;
                        int n = mappingRelation.parameterTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Type parameterType = typeArray[n2];
                            if (!parameterType.isGround()) {
                                TypeChecking.this.compilationContext.errorLog.log(mappingRelation.location, "Parameter types of the mapping relation are not completely determined.");
                                continue block0;
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
    }
}

