/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.commands;

import java.util.Collection;

public class CommandSessionImportEntry
implements Comparable<CommandSessionImportEntry> {
    public String moduleName;
    public String localName;
    public boolean persistent;
    public boolean hasError;
    public boolean disabled;

    public CommandSessionImportEntry(String moduleName, String localName, boolean persistent) {
        this.moduleName = moduleName;
        this.localName = localName;
        this.persistent = persistent;
    }

    public CommandSessionImportEntry(String moduleName, String localName) {
        this.moduleName = moduleName;
        this.localName = localName;
    }

    public CommandSessionImportEntry(String moduleName) {
        this(moduleName, "");
    }

    public void addTo(Collection<CommandSessionImportEntry> entries) {
        for (CommandSessionImportEntry entry : entries) {
            if (!entry.moduleName.equals(this.moduleName) || !entry.localName.equals(this.localName)) continue;
            entry.persistent |= this.persistent;
            entry.disabled &= this.disabled;
            return;
        }
        entries.add(this);
    }

    @Override
    public int compareTo(CommandSessionImportEntry o) {
        int cmp = this.moduleName.compareTo(o.moduleName);
        if (cmp != 0) {
            return cmp;
        }
        return this.localName.compareTo(o.localName);
    }

    public String getStatusString() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if (this.persistent) {
            first = false;
            b.append("persistent");
        }
        if (this.disabled) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append("disabled");
        }
        if (this.hasError) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append("has errors");
        }
        return b.toString();
    }
}

