/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.unification;

import java.util.ArrayList;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.scl.runtime.unification.RuntimeUnificationException;
import org.simantics.scl.runtime.unification.UCons;
import org.simantics.scl.runtime.unification.Unification;

public class UPending {
    private static final int STATE_UNFORCED = 0;
    private static final int STATE_CURRENTLY_FORCING = 1;
    private static final int STATE_FORCED = 2;
    private static final int STATE_UNFORCED_CHECK_PENDING = 3;
    private final Function proc;
    private int state = 0;
    private Object value = null;

    public UPending(Function proc) {
        this.proc = proc;
    }

    public Object force() {
        switch (this.state) {
            case 0: {
                this.state = 1;
                this.value = this.proc.apply(Tuple0.INSTANCE);
                this.state = 2;
                return this.value;
            }
            case 1: {
                throw new RuntimeUnificationException("Pending unification node depends recursively on itself.");
            }
            case 2: {
                return this.value;
            }
            case 3: {
                ArrayList checks = (ArrayList)this.value;
                this.state = 1;
                this.value = this.proc.apply(Tuple0.INSTANCE);
                this.state = 2;
                for (Object check : checks) {
                    UPending.semiUnification(this.value, check);
                }
                return this.value;
            }
        }
        throw new IllegalStateException();
    }

    public void checkAgains(Object check) {
        switch (this.state) {
            case 0: {
                ArrayList<Object> checks = new ArrayList<Object>(2);
                checks.add(check);
                this.state = 3;
                this.value = checks;
                return;
            }
            case 1: {
                throw new RuntimeUnificationException("Pending unification node depends recursively on itself.");
            }
            case 2: {
                UPending.semiUnification(this.value, check);
                return;
            }
            case 3: {
                ArrayList checks = (ArrayList)this.value;
                checks.add(check);
                return;
            }
        }
        throw new IllegalStateException();
    }

    private static void semiUnification(Object constant, Object pendingOrConsOrConstant) {
        if (pendingOrConsOrConstant instanceof UCons) {
            UCons cons = (UCons)pendingOrConsOrConstant;
            Tuple components = (Tuple)cons.tag.destructor.apply(constant);
            Unification.unify(cons.components, components);
            cons.components = components;
        } else if (pendingOrConsOrConstant instanceof UPending) {
            UPending pending = (UPending)pendingOrConsOrConstant;
            Object otherConstant = pending.force();
            if (constant == null ? otherConstant != null : !constant.equals(otherConstant)) {
                throw new RuntimeUnificationException("Unification failed: " + constant + " != " + otherConstant + ".");
            }
        } else if (constant == null ? pendingOrConsOrConstant != null : !constant.equals(pendingOrConsOrConstant)) {
            throw new RuntimeUnificationException();
        }
    }
}

