/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.collections;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.simantics.utils.datastructures.collections.QuadTree;

public class QuadTree2<T> {
    QuadTree<T> qt;
    Map<T, Rectangle2D> map;

    public QuadTree2(Point2D center, double width, double height, int depth) {
        this.qt = new QuadTree(center, width, height, depth);
        this.map = new HashMap<T, Rectangle2D>();
    }

    public void insert(T object, Rectangle2D bounds) {
        Rectangle2D r = this.map.put(object, bounds);
        if (r != null) {
            this.qt.remove(object, r);
        }
        this.qt.insert(object, bounds);
    }

    public void remove(T object) {
        Rectangle2D r = this.map.remove(object);
        if (r != null) {
            this.qt.remove(object, r);
        }
    }

    public boolean contains(T object) {
        return this.map.containsKey(object);
    }

    public void get(Rectangle2D bounds, Set<T> set) {
        this.qt.get(bounds, set);
    }

    public void clear() {
        this.map.clear();
        this.qt.clear();
    }
}

